/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.crypto.Mac;
import net.lingala.zip4j.crypto.AESDecrypter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.BaseInputStream;
import net.lingala.zip4j.unzip.UnzipEngine;

public final class ZipInputStream
extends InputStream {
    private BaseInputStream is;

    /*
     * WARNING - void declaration
     */
    public ZipInputStream(BaseInputStream is) {
        void var1_1;
        this.is = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int read() throws IOException {
        void var1_1;
        int readByte = this.is.read();
        if (readByte != -1) {
            this.is.getUnzipEngine().crc.update(readByte);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int read(byte[] b) throws IOException {
        void var1_1;
        return this.read(b, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public final int read(byte[] b, int off, int len) throws IOException {
        void var3_4;
        int readLen = this.is.read(b, off, len);
        if (readLen > 0 && this.is.getUnzipEngine() != null) {
            UnzipEngine unzipEngine;
            void var2_2;
            void var4_5 = var2_2;
            void var2_3 = unzipEngine;
            unzipEngine = this.is.getUnzipEngine();
            if (var2_3 != null) {
                unzipEngine.crc.update((byte[])var2_3, (int)var4_5, readLen);
            }
        }
        return (int)var3_4;
    }

    public final void close() throws IOException {
        Object object = this;
        try {
            ((ZipInputStream)object).is.close();
            if (((ZipInputStream)object).is.getUnzipEngine() != null) {
                object = ((ZipInputStream)object).is.getUnzipEngine();
                if (((UnzipEngine)object).fileHeader != null) {
                    if (((UnzipEngine)object).fileHeader.encryptionMethod == 99) {
                        if (((UnzipEngine)object).decrypter$71a6d55f != null && ((UnzipEngine)object).decrypter$71a6d55f instanceof AESDecrypter) {
                            byte[] byArray = ((Mac)null).doFinal();
                            byte[] byArray2 = ((AESDecrypter)((UnzipEngine)object).decrypter$71a6d55f).storedMac;
                            byte[] byArray3 = new byte[10];
                            if (byArray2 == null) {
                                throw new ZipException("CRC (MAC) check failed for " + ((UnzipEngine)object).fileHeader.fileName);
                            }
                            System.arraycopy(byArray, 0, byArray3, 0, 10);
                            if (!Arrays.equals(byArray3, byArray2)) {
                                throw new ZipException("invalid CRC (MAC) for file: " + ((UnzipEngine)object).fileHeader.fileName);
                            }
                        }
                    } else if ((((UnzipEngine)object).crc.getValue() & 0xFFFFFFFFL) != ((UnzipEngine)object).fileHeader.getCrc32()) {
                        String string = "invalid CRC for file: " + ((UnzipEngine)object).fileHeader.fileName;
                        if (((UnzipEngine)object).localFileHeader.isEncrypted && ((UnzipEngine)object).localFileHeader.encryptionMethod == 0) {
                            string = String.valueOf(string) + " - Wrong Password?";
                        }
                        throw new ZipException(string);
                    }
                }
                return;
            }
        }
        catch (ZipException zipException) {
            throw new IOException(zipException.getMessage());
        }
    }

    public final int available() throws IOException {
        return this.is.available();
    }

    /*
     * WARNING - void declaration
     */
    public final long skip(long n) throws IOException {
        void var1_1;
        return this.is.skip((long)var1_1);
    }
}

