/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.lingala.zip4j.io.PartInputStream;
import net.lingala.zip4j.unzip.UnzipEngine;

public final class InflaterInputStream
extends PartInputStream {
    private Inflater inflater;
    private byte[] buff;
    private byte[] oneByteBuff = new byte[1];
    private UnzipEngine unzipEngine;
    private long bytesWritten;
    private long uncompressedSize;

    /*
     * WARNING - void declaration
     */
    public InflaterInputStream(RandomAccessFile raf, long len, UnzipEngine unzipEngine) {
        super((RandomAccessFile)var1_1, (long)var2_2, unzipEngine);
        void var2_2;
        void var1_1;
        this.inflater = new Inflater(true);
        this.buff = new byte[4096];
        this.unzipEngine = unzipEngine;
        this.bytesWritten = 0L;
        this.uncompressedSize = unzipEngine.fileHeader.uncompressedSize;
    }

    public final int read() throws IOException {
        if (this.read(this.oneByteBuff, 0, 1) == -1) {
            return -1;
        }
        return this.oneByteBuff[0] & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public final int read(byte[] b) throws IOException {
        void var1_1;
        if (b == null) {
            throw new NullPointerException("input buffer is null");
        }
        return this.read(b, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("input buffer is null");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        try {
            if (this.bytesWritten >= this.uncompressedSize) {
                this.finishInflating();
                return -1;
            }
            while (true) {
                int n;
                if ((n = this.inflater.inflate(b, off, len)) != 0) {
                    this.bytesWritten += (long)n;
                    return n;
                }
                if (this.inflater.finished() || this.inflater.needsDictionary()) {
                    this.finishInflating();
                    return -1;
                }
                if (!this.inflater.needsInput()) continue;
                InflaterInputStream inflaterInputStream = this;
                int n2 = super.read(inflaterInputStream.buff, 0, inflaterInputStream.buff.length);
                if (n2 == -1) {
                    throw new EOFException("Unexpected end of ZLIB input stream");
                }
                inflaterInputStream.inflater.setInput(inflaterInputStream.buff, 0, n2);
            }
        }
        catch (DataFormatException e) {
            void var1_1;
            String s = "Invalid ZLIB data format";
            if (e.getMessage() != null) {
                s = e.getMessage();
            }
            if (this.unzipEngine != null && this.unzipEngine.localFileHeader.isEncrypted && this.unzipEngine.localFileHeader.encryptionMethod == 0) {
                s = String.valueOf(s) + " - Wrong Password?";
            }
            throw new IOException((String)var1_1);
        }
    }

    private void finishInflating() throws IOException {
        byte[] b = new byte[1024];
        while (super.read(b, 0, 1024) != -1) {
        }
        this.checkAndReadAESMacBytes();
    }

    /*
     * WARNING - void declaration
     */
    public final long skip(long n) throws IOException {
        void var2_3;
        if (n < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        int max = (int)Math.min(n, Integer.MAX_VALUE);
        int total = 0;
        byte[] b = new byte[512];
        while (total < max) {
            int len = max - total;
            if (len > 512) {
                len = 512;
            }
            if ((len = this.read(b, 0, len)) == -1) break;
            total += len;
        }
        return (long)var2_3;
    }

    public final int available() {
        if (this.inflater.finished()) {
            return 0;
        }
        return 1;
    }

    public final void close() throws IOException {
        this.inflater.end();
        super.close();
    }

    public final UnzipEngine getUnzipEngine() {
        return super.getUnzipEngine();
    }
}

