/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.core;

import com.google.gson.FieldAttributes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.lingala.zip4j.core.HeaderReader;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;

public final class ZipFile {
    private String file;
    private int mode;
    public ZipModel zipModel;
    public ProgressMonitor progressMonitor;

    /*
     * WARNING - void declaration
     */
    public ZipFile(String zipFile) throws ZipException {
        this(new File((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ZipFile(File zipFile) throws ZipException {
        void var1_1;
        this.file = var1_1.getPath();
        this.mode = 2;
        this.progressMonitor = new ProgressMonitor();
    }

    /*
     * WARNING - void declaration
     */
    public final void readZipInfo() throws ZipException {
        if (!FieldAttributes.checkFileExists(this.file)) {
            throw new ZipException("zip file does not exist");
        }
        if (!FieldAttributes.checkFileReadAccess(this.file)) {
            throw new ZipException("no read access for the input zip file");
        }
        if (this.mode != 2) {
            throw new ZipException("Invalid mode");
        }
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(new File(this.file), "r");
                if (this.zipModel == null) {
                    HeaderReader headerReader = new HeaderReader(raf);
                    v0.zipModel = new ZipModel();
                    headerReader.zipModel.endCentralDirRecord = headerReader.readEndOfCentralDirectoryRecord();
                    headerReader.zipModel.zip64EndCentralDirLocator = headerReader.readZip64EndCentralDirLocator();
                    if (headerReader.zipModel.isZip64Format) {
                        headerReader.zipModel.zip64EndCentralDirRecord = headerReader.readZip64EndCentralDirRec();
                        headerReader.zipModel.splitArchive = headerReader.zipModel.zip64EndCentralDirRecord != null && headerReader.zipModel.zip64EndCentralDirRecord.noOfThisDisk > 0;
                    }
                    headerReader.zipModel.centralDirectory = headerReader.readCentralDirectory();
                    this.zipModel = headerReader.zipModel;
                    if (this.zipModel != null) {
                        this.zipModel.zipFile = this.file;
                    }
                }
            }
            catch (FileNotFoundException e) {
                void var2_3;
                throw new ZipException((Throwable)var2_3);
            }
        }
        catch (Throwable throwable) {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        try {
            void var1_1;
            var1_1.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

