/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.core;

import com.google.gson.FieldAttributes;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.CentralDirectory;
import net.lingala.zip4j.model.DigitalSignature;
import net.lingala.zip4j.model.EndCentralDirRecord;
import net.lingala.zip4j.model.ExtraDataRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.Zip64EndCentralDirLocator;
import net.lingala.zip4j.model.Zip64EndCentralDirRecord;
import net.lingala.zip4j.model.Zip64ExtendedInfo;
import net.lingala.zip4j.model.ZipModel;

public final class HeaderReader {
    private RandomAccessFile zip4jRaf = null;
    ZipModel zipModel;

    /*
     * WARNING - void declaration
     */
    public HeaderReader(RandomAccessFile zip4jRaf) {
        void var1_1;
        this.zip4jRaf = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final EndCentralDirRecord readEndOfCentralDirectoryRecord() throws ZipException {
        if (this.zip4jRaf == null) {
            throw new ZipException("random access file was null", 0);
        }
        try {
            void var2_6;
            byte[] ebs = new byte[4];
            long pos = this.zip4jRaf.length() - 22L;
            EndCentralDirRecord endCentralDirRecord = new EndCentralDirRecord();
            int counter = 0;
            do {
                this.zip4jRaf.seek(pos--);
            } while ((long)FieldAttributes.readLeInt(this.zip4jRaf, ebs) != 101010256L && ++counter <= 3000);
            if ((long)FieldAttributes.readIntLittleEndian$49634b7a(ebs) != 101010256L) {
                throw new ZipException("zip headers not found. probably not a zip file");
            }
            byte[] intBuff = new byte[4];
            byte[] shortBuff = new byte[2];
            HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
            endCentralDirRecord.noOfThisDisk = FieldAttributes.readShortLittleEndian(shortBuff, 0);
            HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
            HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
            HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
            endCentralDirRecord.totNoOfEntriesInCentralDir = FieldAttributes.readShortLittleEndian(shortBuff, 0);
            HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
            HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
            byte[] longBuff = HeaderReader.getLongByteFromIntByte(intBuff);
            endCentralDirRecord.offsetOfStartOfCentralDir = FieldAttributes.readLongLittleEndian$49634b7b(longBuff);
            HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
            int commentLength = FieldAttributes.readShortLittleEndian((byte[])var2_6, 0);
            if (commentLength > 0) {
                byte[] commentBuf = new byte[commentLength];
                HeaderReader.readIntoBuff(this.zip4jRaf, commentBuf);
                new String(commentBuf);
            }
            this.zipModel.splitArchive = endCentralDirRecord.noOfThisDisk > 0;
            return endCentralDirRecord;
        }
        catch (IOException e) {
            void var1_4;
            throw new ZipException("Probably not a zip file or a corrupted zip file", (Throwable)var1_4, 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    final CentralDirectory readCentralDirectory() throws ZipException {
        if (this.zip4jRaf == null) {
            throw new ZipException("random access file was null", 0);
        }
        if (this.zipModel.endCentralDirRecord == null) {
            throw new ZipException("EndCentralRecord was null, maybe a corrupt zip file");
        }
        try {
            void var2_3;
            CentralDirectory centralDirectory = new CentralDirectory();
            ArrayList<FileHeader> fileHeaderList = new ArrayList<FileHeader>();
            EndCentralDirRecord endCentralDirRecord = this.zipModel.endCentralDirRecord;
            long offSetStartCentralDir = endCentralDirRecord.offsetOfStartOfCentralDir;
            int centralDirEntryCount = endCentralDirRecord.totNoOfEntriesInCentralDir;
            if (this.zipModel.isZip64Format) {
                offSetStartCentralDir = this.zipModel.zip64EndCentralDirRecord.offsetStartCenDirWRTStartDiskNo;
                centralDirEntryCount = (int)this.zipModel.zip64EndCentralDirRecord.totNoOfEntriesInCentralDir;
            }
            this.zip4jRaf.seek(offSetStartCentralDir);
            byte[] intBuff = new byte[4];
            byte[] shortBuff = new byte[2];
            int i = 0;
            while (i < centralDirEntryCount) {
                AESExtraDataRecord aESExtraDataRecord;
                Zip64ExtendedInfo zip64ExtendedInfo;
                Object fileName;
                int extraFieldLength22;
                FileHeader fileHeader = new FileHeader();
                HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
                if ((long)FieldAttributes.readIntLittleEndian$49634b7a(intBuff) != 33639248L) {
                    throw new ZipException("Expected central directory entry not found (#" + (i + 1) + ")");
                }
                HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
                HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
                HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
                boolean bl = fileHeader.fileNameUTF8Encoded = (FieldAttributes.readShortLittleEndian(shortBuff, 0) & 0x800) != 0;
                if ((shortBuff[0] & 1) != 0) {
                    fileHeader.isEncrypted = true;
                }
                shortBuff.clone();
                HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
                fileHeader.compressionMethod = FieldAttributes.readShortLittleEndian(shortBuff, 0);
                HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
                fileHeader.lastModFileTime = FieldAttributes.readIntLittleEndian$49634b7a(intBuff);
                HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
                fileHeader.crc32 = FieldAttributes.readIntLittleEndian$49634b7a(intBuff);
                fileHeader.crcBuff = (byte[])intBuff.clone();
                HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
                byte[] longBuff = HeaderReader.getLongByteFromIntByte(intBuff);
                fileHeader.compressedSize = FieldAttributes.readLongLittleEndian$49634b7b(longBuff);
                HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
                longBuff = HeaderReader.getLongByteFromIntByte(intBuff);
                fileHeader.uncompressedSize = FieldAttributes.readLongLittleEndian$49634b7b(longBuff);
                HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
                int fileNameLength = FieldAttributes.readShortLittleEndian(shortBuff, 0);
                HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
                fileHeader.extraFieldLength = extraFieldLength22 = FieldAttributes.readShortLittleEndian(shortBuff, 0);
                HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
                int fileCommentLength = FieldAttributes.readShortLittleEndian(shortBuff, 0);
                new String(shortBuff);
                HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
                fileHeader.diskNumberStart = FieldAttributes.readShortLittleEndian(shortBuff, 0);
                HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
                shortBuff.clone();
                HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
                fileHeader.externalFileAttr = (byte[])intBuff.clone();
                HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
                byte[] extraFieldLength22 = HeaderReader.getLongByteFromIntByte(intBuff);
                fileHeader.offsetLocalHeader = FieldAttributes.readLongLittleEndian$49634b7b(extraFieldLength22) & 0xFFFFFFFFL;
                if (fileNameLength > 0) {
                    byte[] fileNameBuf = new byte[fileNameLength];
                    HeaderReader.readIntoBuff(this.zip4jRaf, fileNameBuf);
                    fileName = FieldAttributes.isStringNotNullAndNotEmpty(null) ? new String(fileNameBuf, null) : FieldAttributes.decodeFileName((byte[])fileName, fileHeader.fileNameUTF8Encoded);
                    if (fileName == null) {
                        throw new ZipException("fileName is null when reading central directory");
                    }
                    if (((String)fileName).indexOf(":" + System.getProperty("file.separator")) >= 0) {
                        fileName = ((String)fileName).substring(((String)fileName).indexOf(":" + System.getProperty("file.separator")) + 2);
                    }
                    fileHeader.fileName = fileName;
                    fileHeader.isDirectory = ((String)fileName).endsWith("/") || ((String)fileName).endsWith("\\");
                } else {
                    fileHeader.fileName = null;
                }
                FileHeader fileHeader2 = fileHeader;
                fileName = this;
                if (((HeaderReader)fileName).zip4jRaf == null) {
                    throw new ZipException("invalid file handler when trying to read extra data record");
                }
                int n = fileHeader2.extraFieldLength;
                if (n > 0) {
                    fileHeader2.extraDataRecords = super.readExtraDataRecords(n);
                }
                fileHeader2 = fileHeader;
                if (fileHeader2.extraDataRecords != null && fileHeader2.extraDataRecords.size() > 0 && (zip64ExtendedInfo = HeaderReader.readZip64ExtendedInfo(fileHeader2.extraDataRecords, fileHeader2.uncompressedSize, fileHeader2.compressedSize, fileHeader2.offsetLocalHeader, fileHeader2.diskNumberStart)) != null) {
                    fileHeader2.zip64ExtendedInfo = zip64ExtendedInfo;
                    if (zip64ExtendedInfo.unCompressedSize != -1L) {
                        fileHeader2.uncompressedSize = zip64ExtendedInfo.unCompressedSize;
                    }
                    if (zip64ExtendedInfo.compressedSize != -1L) {
                        fileHeader2.compressedSize = zip64ExtendedInfo.compressedSize;
                    }
                    if (zip64ExtendedInfo.offsetLocalHeader != -1L) {
                        fileHeader2.offsetLocalHeader = zip64ExtendedInfo.offsetLocalHeader;
                    }
                    if (zip64ExtendedInfo.diskNumberStart != -1) {
                        fileHeader2.diskNumberStart = zip64ExtendedInfo.diskNumberStart;
                    }
                }
                fileHeader2 = fileHeader;
                if (fileHeader2.extraDataRecords != null && fileHeader2.extraDataRecords.size() > 0 && (aESExtraDataRecord = HeaderReader.readAESExtraDataRecord(fileHeader2.extraDataRecords)) != null) {
                    fileHeader2.aesExtraDataRecord = aESExtraDataRecord;
                    fileHeader2.encryptionMethod = 99;
                }
                if (fileCommentLength > 0) {
                    byte[] fileCommentBuf = new byte[fileCommentLength];
                    HeaderReader.readIntoBuff(this.zip4jRaf, fileCommentBuf);
                    new String(fileCommentBuf);
                }
                fileHeaderList.add(fileHeader);
                ++i;
            }
            centralDirectory.fileHeaders = var2_3;
            new DigitalSignature();
            HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
            if ((long)FieldAttributes.readIntLittleEndian$49634b7a(intBuff) != 84233040L) {
                return centralDirectory;
            }
            HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
            int sizeOfData = FieldAttributes.readShortLittleEndian(shortBuff, 0);
            if (sizeOfData > 0) {
                byte[] sigDataBuf = new byte[sizeOfData];
                HeaderReader.readIntoBuff(this.zip4jRaf, sigDataBuf);
                new String(sigDataBuf);
            }
            return centralDirectory;
        }
        catch (IOException e) {
            void var1_2;
            throw new ZipException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList readExtraDataRecords(int extraFieldLength) throws ZipException {
        if (extraFieldLength <= 0) {
            return null;
        }
        try {
            byte[] extraFieldBuf = new byte[extraFieldLength];
            this.zip4jRaf.read(extraFieldBuf);
            int counter = 0;
            ArrayList<ExtraDataRecord> extraDataList = new ArrayList<ExtraDataRecord>();
            while (counter < extraFieldLength) {
                ExtraDataRecord extraDataRecord = new ExtraDataRecord();
                int header = FieldAttributes.readShortLittleEndian(extraFieldBuf, counter);
                extraDataRecord.header = header;
                int sizeOfRec = FieldAttributes.readShortLittleEndian(extraFieldBuf, counter += 2);
                if (sizeOfRec + 2 > extraFieldLength) {
                    short s = FieldAttributes.readShortBigEndian(extraFieldBuf, counter);
                    sizeOfRec = s;
                    if (s + 2 > extraFieldLength) break;
                }
                extraDataRecord.sizeOfData = sizeOfRec;
                counter += 2;
                if (sizeOfRec > 0) {
                    byte[] data = new byte[sizeOfRec];
                    System.arraycopy(extraFieldBuf, counter, data, 0, sizeOfRec);
                    extraDataRecord.data = data;
                }
                counter += sizeOfRec;
                extraDataList.add(extraDataRecord);
            }
            if (extraDataList.size() > 0) {
                return extraDataList;
            }
            return null;
        }
        catch (IOException e) {
            void var2_3;
            throw new ZipException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    final Zip64EndCentralDirLocator readZip64EndCentralDirLocator() throws ZipException {
        byte[] longBuff;
        byte[] intBuff;
        byte[] byArray;
        HeaderReader headerReader;
        Zip64EndCentralDirLocator zip64EndCentralDirLocator;
        if (this.zip4jRaf == null) {
            throw new ZipException("invalid file handler when trying to read Zip64EndCentralDirLocator");
        }
        try {
            zip64EndCentralDirLocator = new Zip64EndCentralDirLocator();
            headerReader = this;
            try {
                byArray = new byte[4];
                long l = headerReader.zip4jRaf.length() - 22L;
                do {
                    headerReader.zip4jRaf.seek(l--);
                } while ((long)FieldAttributes.readLeInt(headerReader.zip4jRaf, byArray) != 101010256L);
                headerReader.zip4jRaf.seek(headerReader.zip4jRaf.getFilePointer() - 4L - 4L - 8L - 4L - 4L);
            }
            catch (IOException iOException) {
                throw new ZipException(iOException);
            }
            intBuff = new byte[4];
            longBuff = new byte[8];
            HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
            if ((long)FieldAttributes.readIntLittleEndian$49634b7a(intBuff) != 117853008L) {
                this.zipModel.isZip64Format = false;
                return null;
            }
            this.zipModel.isZip64Format = true;
        }
        catch (Exception e) {
            void var1_2;
            throw new ZipException((Throwable)var1_2);
        }
        HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
        HeaderReader.readIntoBuff(this.zip4jRaf, longBuff);
        zip64EndCentralDirLocator.offsetZip64EndOfCentralDirRec = FieldAttributes.readLongLittleEndian$49634b7b((byte[])headerReader);
        HeaderReader.readIntoBuff(this.zip4jRaf, byArray);
        return zip64EndCentralDirLocator;
    }

    /*
     * WARNING - void declaration
     */
    final Zip64EndCentralDirRecord readZip64EndCentralDirRec() throws ZipException {
        if (this.zipModel.zip64EndCentralDirLocator == null) {
            throw new ZipException("invalid zip64 end of central directory locator");
        }
        long offSetStartOfZip64CentralDir = this.zipModel.zip64EndCentralDirLocator.offsetZip64EndOfCentralDirRec;
        if (offSetStartOfZip64CentralDir < 0L) {
            throw new ZipException("invalid offset for start of end of central directory record");
        }
        try {
            void var3_5;
            this.zip4jRaf.seek(offSetStartOfZip64CentralDir);
            Zip64EndCentralDirRecord zip64EndCentralDirRecord = new Zip64EndCentralDirRecord();
            byte[] shortBuff = new byte[2];
            byte[] intBuff = new byte[4];
            byte[] longBuff = new byte[8];
            HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
            if ((long)FieldAttributes.readIntLittleEndian$49634b7a(intBuff) != 101075792L) {
                throw new ZipException("invalid signature for zip64 end of central directory record");
            }
            HeaderReader.readIntoBuff(this.zip4jRaf, longBuff);
            zip64EndCentralDirRecord.sizeOfZip64EndCentralDirRec = FieldAttributes.readLongLittleEndian$49634b7b(longBuff);
            HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
            HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
            HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
            zip64EndCentralDirRecord.noOfThisDisk = FieldAttributes.readIntLittleEndian$49634b7a(intBuff);
            HeaderReader.readIntoBuff(this.zip4jRaf, (byte[])var3_5);
            HeaderReader.readIntoBuff(this.zip4jRaf, longBuff);
            HeaderReader.readIntoBuff(this.zip4jRaf, longBuff);
            zip64EndCentralDirRecord.totNoOfEntriesInCentralDir = FieldAttributes.readLongLittleEndian$49634b7b(longBuff);
            HeaderReader.readIntoBuff(this.zip4jRaf, longBuff);
            HeaderReader.readIntoBuff(this.zip4jRaf, longBuff);
            zip64EndCentralDirRecord.offsetStartCenDirWRTStartDiskNo = FieldAttributes.readLongLittleEndian$49634b7b(longBuff);
            long extDataSecSize = zip64EndCentralDirRecord.sizeOfZip64EndCentralDirRec - 44L;
            if (extDataSecSize > 0L) {
                void var2_4;
                byte[] extDataSecRecBuf = new byte[(int)extDataSecSize];
                HeaderReader.readIntoBuff(this.zip4jRaf, (byte[])var2_4);
            }
            return zip64EndCentralDirRecord;
        }
        catch (IOException e) {
            void var1_3;
            throw new ZipException((Throwable)var1_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void readAndSaveZip64ExtendedInfo(LocalFileHeader localFileHeader) throws ZipException {
        if (localFileHeader.extraDataRecords == null || localFileHeader.extraDataRecords.size() <= 0) {
            return;
        }
        Zip64ExtendedInfo zip64ExtendedInfo = HeaderReader.readZip64ExtendedInfo(localFileHeader.extraDataRecords, localFileHeader.uncompressedSize, localFileHeader.compressedSize, -1L, -1);
        if (zip64ExtendedInfo != null) {
            if (zip64ExtendedInfo.unCompressedSize != -1L) {
                localFileHeader.uncompressedSize = zip64ExtendedInfo.unCompressedSize;
            }
            if (zip64ExtendedInfo.compressedSize != -1L) {
                void var1_1;
                var0.compressedSize = var1_1.compressedSize;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Zip64ExtendedInfo readZip64ExtendedInfo(ArrayList extraDataRecords, long unCompressedSize, long compressedSize, long offsetLocalHeader, int diskNumberStart) throws ZipException {
        Zip64ExtendedInfo zip64ExtendedInfo;
        void var8_5;
        int i = 0;
        while (var8_5 < ((ArrayList)((Object)zip64ExtendedInfo)).size()) {
            ExtraDataRecord extraDataRecord = (ExtraDataRecord)extraDataRecords.get(i);
            if (extraDataRecord != null && extraDataRecord.header == 1L) {
                long val;
                Zip64ExtendedInfo zip64ExtendedInfo2 = new Zip64ExtendedInfo();
                byte[] byteBuff = extraDataRecord.data;
                if (extraDataRecord.sizeOfData <= 0) break;
                byte[] longByteBuff = new byte[8];
                byte[] intByteBuff = new byte[4];
                int counter = 0;
                boolean valueAdded = false;
                if ((unCompressedSize & 0xFFFFL) == 65535L && extraDataRecord.sizeOfData > 0) {
                    System.arraycopy(byteBuff, 0, longByteBuff, 0, 8);
                    zip64ExtendedInfo2.unCompressedSize = val = FieldAttributes.readLongLittleEndian$49634b7b(longByteBuff);
                    counter += 8;
                    valueAdded = true;
                }
                if ((compressedSize & 0xFFFFL) == 65535L && counter < extraDataRecord.sizeOfData) {
                    System.arraycopy(byteBuff, counter, longByteBuff, 0, 8);
                    zip64ExtendedInfo2.compressedSize = val = FieldAttributes.readLongLittleEndian$49634b7b(longByteBuff);
                    counter += 8;
                    valueAdded = true;
                }
                if ((offsetLocalHeader & 0xFFFFL) == 65535L && counter < extraDataRecord.sizeOfData) {
                    System.arraycopy(byteBuff, counter, longByteBuff, 0, 8);
                    zip64ExtendedInfo2.offsetLocalHeader = val = FieldAttributes.readLongLittleEndian$49634b7b(longByteBuff);
                    counter += 8;
                    valueAdded = true;
                }
                if ((diskNumberStart & 0xFFFF) == 65535 && counter < extraDataRecord.sizeOfData) {
                    int val2;
                    System.arraycopy(byteBuff, counter, intByteBuff, 0, 4);
                    zip64ExtendedInfo2.diskNumberStart = val2 = FieldAttributes.readIntLittleEndian$49634b7a(intByteBuff);
                    valueAdded = true;
                }
                if (!valueAdded) break;
                return zip64ExtendedInfo;
            }
            ++var8_5;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final LocalFileHeader readLocalFileHeader(FileHeader fileHeader) throws ZipException {
        if (fileHeader == null || this.zip4jRaf == null) {
            throw new ZipException("invalid read parameters for local header");
        }
        long locHdrOffset = fileHeader.offsetLocalHeader;
        if (fileHeader.zip64ExtendedInfo != null && fileHeader.zip64ExtendedInfo.offsetLocalHeader > 0L) {
            locHdrOffset = fileHeader.offsetLocalHeader;
        }
        if (locHdrOffset < 0L) {
            throw new ZipException("invalid local header offset");
        }
        try {
            AESExtraDataRecord aESExtraDataRecord;
            void var2_2;
            int extraFieldLength;
            this.zip4jRaf.seek(locHdrOffset);
            int length = 0;
            LocalFileHeader localFileHeader = new LocalFileHeader();
            byte[] shortBuff = new byte[2];
            byte[] intBuff = new byte[4];
            HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
            if ((long)FieldAttributes.readIntLittleEndian$49634b7a(intBuff) != 67324752L) {
                throw new ZipException("invalid local header signature for file: " + fileHeader.fileName);
            }
            length += 4;
            HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
            length += 2;
            HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
            localFileHeader.fileNameUTF8Encoded = (FieldAttributes.readShortLittleEndian(shortBuff, 0) & 0x800) != 0;
            byte firstByte = shortBuff[0];
            if ((firstByte & 1) != 0) {
                localFileHeader.isEncrypted = true;
            }
            length += 2;
            HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
            localFileHeader.compressionMethod = FieldAttributes.readShortLittleEndian(shortBuff, 0);
            length += 2;
            HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
            length += 4;
            HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
            localFileHeader.crc32 = FieldAttributes.readIntLittleEndian$49634b7a(intBuff);
            intBuff.clone();
            length += 4;
            HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
            byte[] longBuff = HeaderReader.getLongByteFromIntByte(intBuff);
            localFileHeader.compressedSize = FieldAttributes.readLongLittleEndian$49634b7b(longBuff);
            length += 4;
            HeaderReader.readIntoBuff(this.zip4jRaf, intBuff);
            longBuff = HeaderReader.getLongByteFromIntByte(intBuff);
            localFileHeader.uncompressedSize = FieldAttributes.readLongLittleEndian$49634b7b(longBuff);
            length += 4;
            HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
            int fileNameLength = FieldAttributes.readShortLittleEndian(shortBuff, 0);
            length += 2;
            HeaderReader.readIntoBuff(this.zip4jRaf, shortBuff);
            localFileHeader.extraFieldLength = extraFieldLength = FieldAttributes.readShortLittleEndian(shortBuff, 0);
            length += 2;
            if (fileNameLength > 0) {
                byte[] fileNameBuf = new byte[fileNameLength];
                HeaderReader.readIntoBuff(this.zip4jRaf, fileNameBuf);
                String fileName22 = FieldAttributes.decodeFileName(fileNameBuf, localFileHeader.fileNameUTF8Encoded);
                if (fileName22 == null) {
                    throw new ZipException("file name is null, cannot assign file name to local file header");
                }
                if (fileName22.indexOf(":" + System.getProperty("file.separator")) >= 0) {
                    fileName22 = fileName22.substring(fileName22.indexOf(":" + System.getProperty("file.separator")) + 2);
                }
                localFileHeader.fileName = fileName22;
                int fileName22 = fileNameLength + 30;
            } else {
                localFileHeader.fileName = null;
            }
            LocalFileHeader localFileHeader2 = localFileHeader;
            HeaderReader headerReader = this;
            if (headerReader.zip4jRaf == null) {
                throw new ZipException("invalid file handler when trying to read extra data record");
            }
            int n = localFileHeader2.extraFieldLength;
            if (n > 0) {
                localFileHeader2.extraDataRecords = headerReader.readExtraDataRecords(n);
            }
            localFileHeader.offsetStartOfData = var2_2 + (long)(fileName22 += extraFieldLength);
            HeaderReader.readAndSaveZip64ExtendedInfo(localFileHeader);
            localFileHeader2 = localFileHeader;
            if (localFileHeader2.extraDataRecords != null && localFileHeader2.extraDataRecords.size() > 0 && (aESExtraDataRecord = HeaderReader.readAESExtraDataRecord(localFileHeader2.extraDataRecords)) != null) {
                localFileHeader2.aesExtraDataRecord = aESExtraDataRecord;
                localFileHeader2.encryptionMethod = 99;
            }
            if (localFileHeader.isEncrypted && localFileHeader.encryptionMethod != 99) {
                localFileHeader.encryptionMethod = (firstByte & 0x40) == 64 ? 1 : 0;
            }
            if (localFileHeader.crc32 <= 0L) {
                localFileHeader.crc32 = fileHeader.getCrc32();
            }
            if (localFileHeader.compressedSize <= 0L) {
                localFileHeader.compressedSize = fileHeader.compressedSize;
            }
            if (localFileHeader.uncompressedSize <= 0L) {
                void var1_1;
                localFileHeader.uncompressedSize = var1_1.uncompressedSize;
            }
            return localFileHeader;
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static AESExtraDataRecord readAESExtraDataRecord(ArrayList extraDataRecords) throws ZipException {
        AESExtraDataRecord aESExtraDataRecord;
        void var1_1;
        if (extraDataRecords == null) {
            return null;
        }
        int i = 0;
        while (var1_1 < ((ArrayList)((Object)aESExtraDataRecord)).size()) {
            ExtraDataRecord extraDataRecord = (ExtraDataRecord)extraDataRecords.get(i);
            if (extraDataRecord != null && extraDataRecord.header == 39169L) {
                void var1_2;
                void var2_3;
                if (extraDataRecord.data == null) {
                    throw new ZipException("corrput AES extra data records");
                }
                AESExtraDataRecord aesExtraDataRecord = new AESExtraDataRecord();
                byte[] aesData = extraDataRecord.data;
                byte[] vendorIDBytes = new byte[2];
                System.arraycopy(aesData, 2, vendorIDBytes, 0, 2);
                new String((byte[])var2_3);
                aesExtraDataRecord.aesStrength = aesData[4] & 0xFF;
                aesExtraDataRecord.compressionMethod = FieldAttributes.readShortLittleEndian((byte[])var1_2, 5);
                return aESExtraDataRecord;
            }
            ++var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] readIntoBuff(RandomAccessFile zip4jRaf, byte[] buf) throws ZipException {
        try {
            if (zip4jRaf.read(buf, 0, buf.length) != -1) {
                void var1_2;
                return var1_2;
            }
            throw new ZipException("unexpected end of file when reading short buff");
        }
        catch (IOException e) {
            void var0_1;
            throw new ZipException("IOException when reading short buff", (Throwable)var0_1);
        }
    }

    private static byte[] getLongByteFromIntByte(byte[] intByte) throws ZipException {
        byte[] byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = intByte[0];
        byArray2[1] = intByte[1];
        byArray2[2] = intByte[2];
        byArray2[3] = byArray[3];
        return byArray2;
    }
}

