/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;

public final class JsonWriter
implements Closeable,
Flushable {
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    public final Writer out;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String separator;
    public boolean lenient;
    public boolean htmlSafe;
    private String deferredName;
    public boolean serializeNulls;

    static {
        int n = 0;
        while (n <= 31) {
            JsonWriter.REPLACEMENT_CHARS[n] = String.format("\\u%04x", n);
            ++n;
        }
        JsonWriter.REPLACEMENT_CHARS[34] = "\\\"";
        JsonWriter.REPLACEMENT_CHARS[92] = "\\\\";
        JsonWriter.REPLACEMENT_CHARS[9] = "\\t";
        JsonWriter.REPLACEMENT_CHARS[8] = "\\b";
        JsonWriter.REPLACEMENT_CHARS[10] = "\\n";
        JsonWriter.REPLACEMENT_CHARS[13] = "\\r";
        JsonWriter.REPLACEMENT_CHARS[12] = "\\f";
        String[] stringArray = (String[])REPLACEMENT_CHARS.clone();
        HTML_SAFE_REPLACEMENT_CHARS = stringArray;
        stringArray[60] = "\\u003c";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[62] = "\\u003e";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[38] = "\\u0026";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[61] = "\\u003d";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[39] = "\\u0027";
    }

    public JsonWriter(Writer writer) {
        this.push(6);
        this.separator = ":";
        this.serializeNulls = true;
        this.out = writer;
    }

    public final JsonWriter beginArray() throws IOException {
        this.writeDeferredName();
        return this.open(1, "[");
    }

    public final JsonWriter endArray() throws IOException {
        return this.close(1, 2, "]");
    }

    public final JsonWriter beginObject() throws IOException {
        this.writeDeferredName();
        return this.open(3, "{");
    }

    public final JsonWriter endObject() throws IOException {
        return this.close(3, 5, "}");
    }

    private JsonWriter open(int n, String string) throws IOException {
        this.beforeValue();
        this.push(n);
        this.out.write(string);
        return this;
    }

    private JsonWriter close(int n, int n2, String string) throws IOException {
        int n3 = this.peek();
        if (n3 != n2 && n3 != n) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException("Dangling name: " + this.deferredName);
        }
        --this.stackSize;
        this.out.write(string);
        return this;
    }

    private void push(int n) {
        if (this.stackSize == this.stack.length) {
            int[] nArray = new int[this.stackSize << 1];
            System.arraycopy(this.stack, 0, nArray, 0, this.stackSize);
            this.stack = nArray;
        }
        this.stack[this.stackSize++] = n;
    }

    private int peek() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.stack[this.stackSize - 1];
    }

    private void replaceTop(int n) {
        this.stack[this.stackSize - 1] = n;
    }

    public final JsonWriter name(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("name == null");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException();
        }
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.deferredName = string;
        return this;
    }

    public final void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            JsonWriter jsonWriter = this;
            int n = jsonWriter.peek();
            if (n == 5) {
                jsonWriter.out.write(44);
            } else if (n != 3) {
                throw new IllegalStateException("Nesting problem.");
            }
            jsonWriter.replaceTop(4);
            this.string(this.deferredName);
            this.deferredName = null;
        }
    }

    public final JsonWriter value(String string) throws IOException {
        if (string == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.string(string);
        return this;
    }

    public final JsonWriter nullValue() throws IOException {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue();
        this.out.write("null");
        return this;
    }

    public final JsonWriter value(boolean bl) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(bl ? "true" : "false");
        return this;
    }

    public final JsonWriter value(long l) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(Long.toString(l));
        return this;
    }

    public final JsonWriter value(Number number) throws IOException {
        if (number == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        String string = number.toString();
        if (!this.lenient && (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN"))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + number);
        }
        this.beforeValue();
        this.out.append(string);
        return this;
    }

    @Override
    public final void flush() throws IOException {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.out.flush();
    }

    @Override
    public final void close() throws IOException {
        this.out.close();
        int n = this.stackSize;
        if (n > 1 || n == 1 && this.stack[n - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    private void string(String string) throws IOException {
        String[] stringArray = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        this.out.write("\"");
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            block8: {
                String string2;
                block7: {
                    char c;
                    block9: {
                        block6: {
                            c = string.charAt(n3);
                            if (c >= '\u0080') break block6;
                            string2 = stringArray[c];
                            if (string2 != null) break block7;
                            break block8;
                        }
                        if (c != '\u2028') break block9;
                        string2 = "\\u2028";
                        break block7;
                    }
                    if (c != '\u2029') break block8;
                    string2 = "\\u2029";
                }
                if (n < n3) {
                    this.out.write(string, n, n3 - n);
                }
                this.out.write(string2);
                n = n3 + 1;
            }
            ++n3;
        }
        if (n < n2) {
            this.out.write(string, n, n2 - n);
        }
        this.out.write("\"");
    }

    public final void beforeValue() throws IOException {
        switch (this.peek()) {
            case 7: {
                if (!this.lenient) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case 6: {
                this.replaceTop(7);
                return;
            }
            case 1: {
                this.replaceTop(2);
                return;
            }
            case 2: {
                this.out.append(',');
                return;
            }
            case 4: {
                this.out.append(this.separator);
                this.replaceTop(5);
                return;
            }
        }
        throw new IllegalStateException("Nesting problem.");
    }
}

