/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldAttributes;
import com.google.gson.JsonElement;
import com.google.gson.internal.LazilyParsedNumber;
import java.math.BigInteger;

public final class JsonPrimitive
extends JsonElement {
    private static final Class<?>[] PRIMITIVE_TYPES = new Class[]{Integer.TYPE, Long.TYPE, Short.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE, Boolean.TYPE, Character.TYPE, Integer.class, Long.class, Short.class, Float.class, Double.class, Byte.class, Boolean.class, Character.class};
    public Object value;

    public JsonPrimitive(Boolean bl) {
        this.setValue(bl);
    }

    public JsonPrimitive(Number number) {
        this.setValue(number);
    }

    public JsonPrimitive(String string) {
        this.setValue(string);
    }

    /*
     * Unable to fully structure code
     */
    private void setValue(Object var1_1) {
        block7: {
            if (var1_1 instanceof Character) {
                var1_2 = ((Character)var1_1).charValue();
                this.value = String.valueOf(var1_2);
                return;
            }
            if (var1_1 instanceof Number) ** GOTO lbl-1000
            var2_3 = var1_1;
            if (var2_3 instanceof String) {
                v0 = true;
            } else {
                var2_3 = var2_3.getClass();
                var4_4 = JsonPrimitive.PRIMITIVE_TYPES;
                var3_5 = 0;
                while (var3_5 < 16) {
                    if (var4_4[var3_5].isAssignableFrom(var2_3)) {
                        v0 = true;
                        break block7;
                    }
                    ++var3_5;
                }
                v0 = false;
            }
        }
        if (!v0) {
            v1 = false;
        } else lbl-1000:
        // 2 sources

        {
            v1 = true;
        }
        FieldAttributes.checkArgument(v1);
        this.value = var1_1;
    }

    @Override
    public final boolean getAsBoolean() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return Boolean.parseBoolean(this.getAsString());
    }

    @Override
    public final Number getAsNumber() {
        if (this.value instanceof String) {
            return new LazilyParsedNumber((String)this.value);
        }
        return (Number)this.value;
    }

    @Override
    public final String getAsString() {
        if (this.value instanceof Number) {
            return this.getAsNumber().toString();
        }
        if (this.value instanceof Boolean) {
            return ((Boolean)this.value).toString();
        }
        return (String)this.value;
    }

    @Override
    public final double getAsDouble() {
        if (this.value instanceof Number) {
            return this.getAsNumber().doubleValue();
        }
        return Double.parseDouble(this.getAsString());
    }

    @Override
    public final long getAsLong() {
        if (this.value instanceof Number) {
            return this.getAsNumber().longValue();
        }
        return Long.parseLong(this.getAsString());
    }

    @Override
    public final int getAsInt() {
        if (this.value instanceof Number) {
            return this.getAsNumber().intValue();
        }
        return Integer.parseInt(this.getAsString());
    }

    public final int hashCode() {
        if (this.value == null) {
            return 31;
        }
        if (JsonPrimitive.isIntegral(this)) {
            long l = this.getAsNumber().longValue();
            return (int)(l ^ l >>> 32);
        }
        if (this.value instanceof Number) {
            long l = Double.doubleToLongBits(this.getAsNumber().doubleValue());
            return (int)(l ^ l >>> 32);
        }
        return this.value.hashCode();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (JsonPrimitive)object;
        if (this.value == null) {
            return ((JsonPrimitive)object).value == null;
        }
        if (JsonPrimitive.isIntegral(this) && JsonPrimitive.isIntegral((JsonPrimitive)object)) {
            return this.getAsNumber().longValue() == ((JsonPrimitive)object).getAsNumber().longValue();
        }
        if (this.value instanceof Number && ((JsonPrimitive)object).value instanceof Number) {
            double d;
            double d2 = this.getAsNumber().doubleValue();
            return d2 == (d = ((JsonPrimitive)object).getAsNumber().doubleValue()) || Double.isNaN(d2) && Double.isNaN(d);
        }
        return this.value.equals(((JsonPrimitive)object).value);
    }

    private static boolean isIntegral(JsonPrimitive object) {
        if (((JsonPrimitive)object).value instanceof Number) {
            object = (Number)((JsonPrimitive)object).value;
            return object instanceof BigInteger || object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte;
        }
        return false;
    }
}

