/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.ExclusionStrategy;
import java.lang.reflect.Field;
import java.util.Locale;

public abstract class FieldNamingPolicy
extends Enum<FieldNamingPolicy>
implements ExclusionStrategy {
    public static final /* enum */ FieldNamingPolicy IDENTITY = new FieldNamingPolicy(){

        @Override
        public final String translateName(Field field) {
            return field.getName();
        }
    };
    private static /* enum */ FieldNamingPolicy UPPER_CAMEL_CASE = new FieldNamingPolicy(){

        @Override
        public final String translateName(Field field) {
            return 2.upperCaseFirstLetter(field.getName());
        }
    };
    private static /* enum */ FieldNamingPolicy UPPER_CAMEL_CASE_WITH_SPACES = new FieldNamingPolicy(){

        @Override
        public final String translateName(Field field) {
            return 3.upperCaseFirstLetter(3.separateCamelCase(field.getName(), " "));
        }
    };
    private static /* enum */ FieldNamingPolicy LOWER_CASE_WITH_UNDERSCORES = new FieldNamingPolicy(){

        @Override
        public final String translateName(Field field) {
            return 4.separateCamelCase(field.getName(), "_").toLowerCase(Locale.ENGLISH);
        }
    };
    private static /* enum */ FieldNamingPolicy LOWER_CASE_WITH_DASHES = new FieldNamingPolicy(){

        @Override
        public final String translateName(Field field) {
            return 5.separateCamelCase(field.getName(), "-").toLowerCase(Locale.ENGLISH);
        }
    };

    static {
        FieldNamingPolicy[] fieldNamingPolicyArray = new FieldNamingPolicy[]{IDENTITY, UPPER_CAMEL_CASE, UPPER_CAMEL_CASE_WITH_SPACES, LOWER_CASE_WITH_UNDERSCORES, LOWER_CASE_WITH_DASHES};
    }

    private FieldNamingPolicy() {
    }

    static String separateCamelCase(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (Character.isUpperCase(c) && stringBuilder.length() != 0) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(c);
            ++n;
        }
        return stringBuilder.toString();
    }

    static String upperCaseFirstLetter(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = string.charAt(0);
        int n3 = string.length();
        while (n < n3 - 1) {
            if (Character.isLetter((char)n2)) break;
            stringBuilder.append((char)n2);
            n2 = string.charAt(++n);
        }
        if (!Character.isUpperCase((char)n2)) {
            char c = Character.toUpperCase((char)n2);
            n2 = ++n;
            String string2 = string;
            char c2 = c;
            String string3 = n2 < string2.length() ? String.valueOf(c2) + string2.substring(n2) : String.valueOf(c2);
            return stringBuilder.append(string3).toString();
        }
        return string;
    }

    /* synthetic */ FieldNamingPolicy(String string, int n, byte by) {
        this();
    }
}

