/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.concurrent.ConcurrentHashMap;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;

public final class FieldAttributes
implements ExclusionStrategy<T> {
    public FieldAttributes(Field field) {
        FieldAttributes.checkNotNull(field);
    }

    public static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static JsonElement parse(JsonReader jsonReader) throws JsonParseException {
        boolean bl = true;
        try {
            jsonReader.peek();
            bl = false;
            return TypeAdapters.JSON_ELEMENT.read(jsonReader);
        }
        catch (EOFException eOFException) {
            if (bl) {
                return JsonNull.INSTANCE;
            }
            throw new JsonSyntaxException(eOFException);
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonSyntaxException(numberFormatException);
        }
    }

    public static void write(JsonElement jsonElement, JsonWriter jsonWriter) throws IOException {
        TypeAdapters.JSON_ELEMENT.write(jsonWriter, jsonElement);
    }

    /*
     * WARNING - void declaration
     */
    public static void applyFileAttributes$68aa1e85$fe54379(FileHeader fileHeader, File file) throws ZipException {
        Object object;
        if (fileHeader == null) {
            throw new ZipException("cannot set file properties: file header is null");
        }
        if (!FieldAttributes.checkFileExists(file)) {
            throw new ZipException("cannot set file properties: file doesnot exist");
        }
        File file2 = file;
        FileHeader fileHeader2 = fileHeader;
        if (fileHeader2.lastModFileTime > 0 && file2.exists()) {
            int n = fileHeader2.lastModFileTime;
            int n2 = 2 * (n & 0x1F);
            int n3 = n >> 5 & 0x3F;
            int n4 = n >> 11 & 0x1F;
            int n5 = n >> 16 & 0x1F;
            int n6 = (n >> 21 & 0xF) - 1;
            n = (n >> 25 & 0x7F) + 1980;
            Calendar calendar = Calendar.getInstance();
            calendar.set(n, n6, n5, n4, n3, n2);
            calendar.set(14, 0);
            file2.setLastModified(calendar.getTime().getTime());
        }
        if (object == null) {
            throw new ZipException("invalid file header. cannot set file attributes");
        }
        object = ((FileHeader)object).externalFileAttr;
        if (((FileHeader)object).externalFileAttr != null) {
            switch (object[0]) {
                case 1: {
                    void var1_1;
                    FieldAttributes.setFileReadOnly((File)var1_1);
                    return;
                }
                case 2: 
                case 18: {
                    return;
                }
                case 32: 
                case 48: {
                    return;
                }
                case 3: {
                    void var1_1;
                    FieldAttributes.setFileReadOnly((File)var1_1);
                    return;
                }
                case 33: {
                    void var1_1;
                    FieldAttributes.setFileReadOnly((File)var1_1);
                    return;
                }
                case 34: 
                case 50: {
                    return;
                }
                case 35: {
                    void var1_1;
                    FieldAttributes.setFileReadOnly((File)var1_1);
                    return;
                }
                case 38: {
                    void var1_1;
                    FieldAttributes.setFileReadOnly((File)var1_1);
                }
            }
        }
    }

    public static long readLongLittleEndian$49634b7b(byte[] array) {
        byte[] byArray;
        return (((((((0L | (long)(array[7] & 0xFF)) << 8 | (long)(array[6] & 0xFF)) << 8 | (long)(array[5] & 0xFF)) << 8 | (long)(array[4] & 0xFF)) << 8 | (long)(array[3] & 0xFF)) << 8 | (long)(array[2] & 0xFF)) << 8 | (long)(array[1] & 0xFF)) << 8 | (long)(byArray[0] & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    public static int readLeInt(DataInput di, byte[] b) throws ZipException {
        void var1_2;
        try {
            di.readFully(b, 0, 4);
        }
        catch (IOException e) {
            void var0_1;
            throw new ZipException((Throwable)var0_1);
        }
        return b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF | (var1_2[3] & 0xFF) << 8) << 16;
    }

    /*
     * WARNING - void declaration
     */
    public static int readShortLittleEndian(byte[] b, int off) {
        void var1_1;
        byte[] byArray;
        return b[off] & 0xFF | (byArray[var1_1 + true] & 0xFF) << 8;
    }

    /*
     * WARNING - void declaration
     */
    public static short readShortBigEndian(byte[] array, int pos) {
        void var1_1;
        byte[] byArray;
        return (short)((short)((short)(0 | array[pos] & 0xFF) << 8) | byArray[var1_1 + true] & 0xFF);
    }

    public static int readIntLittleEndian$49634b7a(byte[] b) {
        byte[] byArray;
        return b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF | (byArray[3] & 0xFF) << 8) << 16;
    }

    public static boolean isStringNotNullAndNotEmpty(String str) {
        String string;
        return str != null && string.trim().length() > 0;
    }

    public static boolean checkOutputFolder(String path) throws ZipException {
        if (!FieldAttributes.isStringNotNullAndNotEmpty(path)) {
            throw new ZipException(new NullPointerException("output path is null"));
        }
        File file = new File(path);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new ZipException("output folder is not valid");
            }
            if (!file.canWrite()) {
                throw new ZipException("no write access to output folder");
            }
        } else {
            try {
                File file2;
                file.mkdirs();
                if (!file.isDirectory()) {
                    throw new ZipException("output folder is not valid");
                }
                if (!file2.canWrite()) {
                    throw new ZipException("no write access to destination folder");
                }
            }
            catch (Exception exception) {
                throw new ZipException("Cannot create destination folder");
            }
        }
        return true;
    }

    public static boolean checkFileReadAccess(String path) throws ZipException {
        if (!FieldAttributes.isStringNotNullAndNotEmpty(path)) {
            throw new ZipException("path is null");
        }
        if (!FieldAttributes.checkFileExists(path)) {
            throw new ZipException(new StringBuffer("file does not exist: ").append(path).toString());
        }
        try {
            String string;
            return new File(string).canRead();
        }
        catch (Exception exception) {
            throw new ZipException("cannot read zip file");
        }
    }

    public static boolean checkFileExists(String path) throws ZipException {
        String string;
        if (!FieldAttributes.isStringNotNullAndNotEmpty(path)) {
            throw new ZipException("path is null");
        }
        return FieldAttributes.checkFileExists(new File(string));
    }

    private static boolean checkFileExists(File file) throws ZipException {
        File file2;
        if (file == null) {
            throw new ZipException("cannot check if file exists: input file is null");
        }
        return file2.exists();
    }

    private static void setFileReadOnly(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null. cannot set read only file attribute");
        }
        if (file.exists()) {
            File file2;
            file2.setReadOnly();
        }
    }

    public static String decodeFileName(byte[] data, boolean isUTF8) {
        byte[] byArray;
        if (isUTF8) {
            try {
                return new String(data, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(data);
            }
        }
        return FieldAttributes.getCp850EncodedString(byArray);
    }

    private static String getCp850EncodedString(byte[] data) {
        try {
            return new String(data, "Cp850");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byte[] byArray;
            return new String(byArray);
        }
    }

    public FieldAttributes() {
    }

    @Override
    public final T construct() {
        return new ConcurrentHashMap();
    }
}

