/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class Java7Support {
    private static final boolean IS_JAVA7;
    private static Method isSymbolicLink;
    private static Method toPath;
    private static Object emptyLinkOpts;
    private static Object emptyFileAttributes;

    /*
     * WARNING - void declaration
     */
    public static boolean isSymLink(File file) {
        try {
            Object path = toPath.invoke((Object)file, new Object[0]);
            return (Boolean)isSymbolicLink.invoke(null, path);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            void var0_2;
            throw new RuntimeException((Throwable)var0_2);
        }
    }

    public static boolean isAtLeastJava7() {
        return IS_JAVA7;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        boolean isJava7x = true;
        try {
            void var3_3;
            void var2_2;
            void var1_1;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> files = cl.loadClass("java.nio.file.Files");
            Class<?> path = cl.loadClass("java.nio.file.Path");
            Class<?> fa = cl.loadClass("java.nio.file.attribute.FileAttribute");
            Class<?> linkOption = cl.loadClass("java.nio.file.LinkOption");
            isSymbolicLink = files.getMethod("isSymbolicLink", path);
            files.getMethod("delete", path);
            files.getMethod("readSymbolicLink", path);
            emptyFileAttributes = Array.newInstance(fa, 0);
            files.getMethod("createSymbolicLink", path, path, emptyFileAttributes.getClass());
            emptyLinkOpts = Array.newInstance(var1_1, 0);
            var2_2.getMethod("exists", path, emptyLinkOpts.getClass());
            toPath = File.class.getMethod("toPath", new Class[0]);
            var3_3.getMethod("toFile", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            isJava7x = false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            isJava7x = false;
        }
        IS_JAVA7 = var0;
    }
}

