/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.unzip;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.zip.CRC32;
import net.lingala.zip4j.core.HeaderReader;
import net.lingala.zip4j.crypto.AESDecrypter;
import net.lingala.zip4j.crypto.StandardDecrypter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.InflaterInputStream;
import net.lingala.zip4j.io.PartInputStream;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;

public final class UnzipEngine {
    public ZipModel zipModel;
    public FileHeader fileHeader;
    private int currSplitFileCounter = 0;
    public LocalFileHeader localFileHeader;
    public ExclusionStrategy decrypter$71a6d55f;
    public CRC32 crc;

    /*
     * WARNING - void declaration
     */
    public UnzipEngine(ZipModel zipModel, FileHeader fileHeader) throws ZipException {
        void var2_2;
        void var1_1;
        if (zipModel == null || fileHeader == null) {
            throw new ZipException("Invalid parameters passed to StoreUnzip. One or more of the parameters were null");
        }
        this.zipModel = var1_1;
        this.fileHeader = var2_2;
        this.crc = new CRC32();
    }

    /*
     * WARNING - void declaration
     */
    public final void unzipFile$53a3e906$5e5c67f8(ProgressMonitor progressMonitor, String outPath) throws ZipException {
        void var3_4;
        if (this.zipModel == null || this.fileHeader == null || !FieldAttributes.isStringNotNullAndNotEmpty(outPath)) {
            throw new ZipException("Invalid parameters passed during unzipping file. One or more of the parameters were null");
        }
        ZipInputStream is = null;
        FileOutputStream os = null;
        try {
            try {
                void var2_3;
                int readLength2;
                byte[] buff = new byte[4096];
                is = this.getInputStream();
                os = this.getOutputStream$4422a843(outPath);
                while ((readLength2 = ((InputStream)is).read(buff)) != -1) {
                    ((OutputStream)os).write(buff, 0, readLength2);
                    long l = readLength2;
                    ProgressMonitor readLength2 = progressMonitor;
                    readLength2.workCompleted += l;
                    if (readLength2.totalWork <= 0L) continue;
                    readLength2.percentDone = (int)(readLength2.workCompleted * 100L / readLength2.totalWork);
                    if (readLength2.percentDone <= 100) continue;
                    readLength2.percentDone = 100;
                }
                UnzipEngine.closeStreams(is, os);
                FieldAttributes.applyFileAttributes$68aa1e85$fe54379(this.fileHeader, new File(this.getOutputFileNameWithPath((String)var2_3, null)));
            }
            catch (IOException e) {
                throw new ZipException(e);
            }
            catch (Exception e) {
                throw new ZipException(e);
            }
        }
        catch (Throwable throwable) {
            UnzipEngine.closeStreams(is, os);
            throw throwable;
        }
        UnzipEngine.closeStreams((InputStream)var3_4, os);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ZipInputStream getInputStream() throws ZipException {
        if (this.fileHeader == null) {
            throw new ZipException("file header is null, cannot get inputstream");
        }
        RandomAccessFile raf = null;
        try {
            raf = this.createFileHandler("r");
            Object errMsg22 = "local header and file header do not match";
            if (!this.checkLocalHeader()) {
                throw new ZipException((String)errMsg22);
            }
            RandomAccessFile randomAccessFile = raf;
            errMsg22 = this;
            if (((UnzipEngine)errMsg22).localFileHeader == null) {
                throw new ZipException("local file header is null, cannot initialize input stream");
            }
            try {
                if (((UnzipEngine)errMsg22).localFileHeader == null) {
                    throw new ZipException("local file header is null, cannot init decrypter");
                }
                if (((UnzipEngine)errMsg22).localFileHeader.isEncrypted) {
                    if (((UnzipEngine)errMsg22).localFileHeader.encryptionMethod == 0) {
                        FileHeader fileHeader = ((UnzipEngine)errMsg22).fileHeader;
                        super.getStandardDecrypterHeaderBytes(randomAccessFile);
                        ((UnzipEngine)errMsg22).decrypter$71a6d55f = new StandardDecrypter(fileHeader);
                    } else {
                        if (((UnzipEngine)errMsg22).localFileHeader.encryptionMethod != 99) throw new ZipException("unsupported encryption method");
                        LocalFileHeader localFileHeader = ((UnzipEngine)errMsg22).localFileHeader;
                        super.getAESSalt(randomAccessFile);
                        UnzipEngine.getAESPasswordVerifier(randomAccessFile);
                        ((UnzipEngine)errMsg22).decrypter$71a6d55f = new AESDecrypter(localFileHeader);
                    }
                }
            }
            catch (ZipException zipException) {
                throw zipException;
            }
            catch (Exception errMsg22) {
                throw new ZipException(errMsg22);
            }
            long comprSize = this.localFileHeader.compressedSize;
            long offsetStartOfData = this.localFileHeader.offsetStartOfData;
            if (this.localFileHeader.isEncrypted) {
                if (this.localFileHeader.encryptionMethod == 99) {
                    if (!(this.decrypter$71a6d55f instanceof AESDecrypter)) throw new ZipException("invalid decryptor when trying to calculate compressed size for AES encrypted file: " + this.fileHeader.fileName);
                    comprSize -= (long)(((AESDecrypter)this.decrypter$71a6d55f).SALT_LENGTH + 2 + 10);
                    offsetStartOfData += (long)(((AESDecrypter)this.decrypter$71a6d55f).SALT_LENGTH + 2);
                } else if (this.localFileHeader.encryptionMethod == 0) {
                    comprSize -= 12L;
                    offsetStartOfData += 12L;
                }
            }
            int compressionMethod = this.fileHeader.compressionMethod;
            if (this.fileHeader.encryptionMethod == 99) {
                if (this.fileHeader.aesExtraDataRecord == null) throw new ZipException("AESExtraDataRecord does not exist for AES encrypted file: " + this.fileHeader.fileName);
                compressionMethod = this.fileHeader.aesExtraDataRecord.compressionMethod;
            }
            raf.seek(offsetStartOfData);
            switch (compressionMethod) {
                case 0: {
                    return new ZipInputStream(new PartInputStream(raf, comprSize, this));
                }
                case 8: {
                    void var3_8;
                    return new ZipInputStream(new InflaterInputStream(raf, (long)var3_8, this));
                }
            }
            throw new ZipException("compression type not supported");
        }
        catch (ZipException e) {
            if (raf == null) throw e;
            try {
                raf.close();
                throw e;
            }
            catch (IOException iOException) {}
            throw e;
        }
        catch (Exception e) {
            void var2_6;
            if (raf == null) throw new ZipException((Throwable)var2_6);
            try {
                void var1_1;
                var1_1.close();
                throw new ZipException((Throwable)var2_6);
            }
            catch (IOException iOException) {}
            throw new ZipException((Throwable)var2_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getStandardDecrypterHeaderBytes(RandomAccessFile raf) throws ZipException {
        try {
            void var1_1;
            byte[] headerBytes = new byte[12];
            raf.seek(this.localFileHeader.offsetStartOfData);
            var1_1.read(headerBytes, 0, 12);
            return headerBytes;
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
        catch (Exception e) {
            void var2_4;
            throw new ZipException((Throwable)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getAESSalt(RandomAccessFile raf) throws ZipException {
        if (this.localFileHeader.aesExtraDataRecord == null) {
            return null;
        }
        try {
            void var1_1;
            int n;
            AESExtraDataRecord aESExtraDataRecord = this.localFileHeader.aesExtraDataRecord;
            if (aESExtraDataRecord == null) {
                throw new ZipException("unable to determine salt length: AESExtraDataRecord is null");
            }
            switch (aESExtraDataRecord.aesStrength) {
                case 1: {
                    n = 8;
                    break;
                }
                case 2: {
                    n = 12;
                    break;
                }
                case 3: {
                    n = 16;
                    break;
                }
                default: {
                    throw new ZipException("unable to determine salt length: invalid aes key strength");
                }
            }
            byte[] saltBytes = new byte[n];
            raf.seek(this.localFileHeader.offsetStartOfData);
            var1_1.read(saltBytes);
            return saltBytes;
        }
        catch (IOException e) {
            void var2_3;
            throw new ZipException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] getAESPasswordVerifier(RandomAccessFile raf) throws ZipException {
        try {
            RandomAccessFile randomAccessFile;
            byte[] pvBytes = new byte[2];
            randomAccessFile.read(pvBytes);
            return pvBytes;
        }
        catch (IOException e) {
            void var1_2;
            throw new ZipException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkLocalHeader() throws ZipException {
        RandomAccessFile rafForLH;
        block15: {
            rafForLH = null;
            try {
                rafForLH = this.checkSplitFile();
                if (rafForLH == null) {
                    rafForLH = new RandomAccessFile(new File(this.zipModel.zipFile), "r");
                }
                HeaderReader headerReader = new HeaderReader(rafForLH);
                this.localFileHeader = headerReader.readLocalFileHeader(this.fileHeader);
                if (this.localFileHeader == null) {
                    throw new ZipException("error reading local file header. Is this a valid zip file?");
                }
                if (this.localFileHeader.compressionMethod == this.fileHeader.compressionMethod) break block15;
                if (rafForLH == null) return false;
            }
            catch (FileNotFoundException e) {
                try {
                    void var2_3;
                    throw new ZipException((Throwable)var2_3);
                }
                catch (Throwable throwable) {
                    if (rafForLH == null) throw throwable;
                    try {
                        void var1_1;
                        var1_1.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
            }
            try {
                rafForLH.close();
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            catch (Exception exception) {}
            return false;
        }
        if (rafForLH == null) return true;
        try {
            rafForLH.close();
            return true;
        }
        catch (IOException iOException) {
            return true;
        }
        catch (Exception exception) {}
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private RandomAccessFile checkSplitFile() throws ZipException {
        if (this.zipModel.splitArchive) {
            void partFile22;
            int diskNumberStartOfFile = this.fileHeader.diskNumberStart;
            this.currSplitFileCounter = diskNumberStartOfFile + 1;
            String curZipFile = this.zipModel.zipFile;
            String partFile22 = diskNumberStartOfFile == this.zipModel.endCentralDirRecord.noOfThisDisk ? this.zipModel.zipFile : (partFile22 >= 9 ? String.valueOf(curZipFile.substring(0, curZipFile.lastIndexOf("."))) + ".z" + (int)(partFile22 + true) : String.valueOf(curZipFile.substring(0, curZipFile.lastIndexOf("."))) + ".z0" + (int)(partFile22 + true));
            try {
                RandomAccessFile raf = new RandomAccessFile(partFile22, "r");
                if (this.currSplitFileCounter == 1) {
                    void var2_5;
                    byte[] splitSig = new byte[4];
                    raf.read(splitSig);
                    if ((long)FieldAttributes.readIntLittleEndian$49634b7a((byte[])var2_5) != 134695760L) {
                        throw new ZipException("invalid first part split file signature");
                    }
                }
                return raf;
            }
            catch (FileNotFoundException e) {
                throw new ZipException(e);
            }
            catch (IOException e) {
                void var1_4;
                throw new ZipException((Throwable)var1_4);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private RandomAccessFile createFileHandler(String mode) throws ZipException {
        if (this.zipModel == null || !FieldAttributes.isStringNotNullAndNotEmpty(this.zipModel.zipFile)) {
            throw new ZipException("input parameter is null in getFilePointer");
        }
        try {
            RandomAccessFile raf;
            raf = this.zipModel.splitArchive ? this.checkSplitFile() : new RandomAccessFile(new File(this.zipModel.zipFile), (String)((Object)raf));
            return raf;
        }
        catch (FileNotFoundException e) {
            throw new ZipException(e);
        }
        catch (Exception e) {
            void var1_3;
            throw new ZipException((Throwable)var1_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private FileOutputStream getOutputStream$4422a843(String outPath) throws ZipException {
        if (!FieldAttributes.isStringNotNullAndNotEmpty(outPath)) {
            throw new ZipException("invalid output path");
        }
        try {
            File file = new File(this.getOutputFileNameWithPath(outPath, null));
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            void var1_2;
            throw new ZipException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getOutputFileNameWithPath(String outPath, String newFileName) throws ZipException {
        void var2_2;
        void var1_1;
        if (!FieldAttributes.isStringNotNullAndNotEmpty(null)) {
            String fileName = this.fileHeader.fileName;
        }
        return String.valueOf(var1_1) + System.getProperty("file.separator") + (String)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final RandomAccessFile startNextSplitFile() throws IOException, FileNotFoundException {
        void var1_1;
        String partFile;
        String currZipFile = this.zipModel.zipFile;
        partFile = this.currSplitFileCounter == this.zipModel.endCentralDirRecord.noOfThisDisk ? this.zipModel.zipFile : (this.currSplitFileCounter >= 9 ? String.valueOf(partFile.substring(0, partFile.lastIndexOf("."))) + ".z" + (this.currSplitFileCounter + 1) : String.valueOf(partFile.substring(0, partFile.lastIndexOf("."))) + ".z0" + (this.currSplitFileCounter + 1));
        ++this.currSplitFileCounter;
        try {
            if (!FieldAttributes.checkFileExists(partFile)) {
                throw new IOException("zip split file does not exist: " + partFile);
            }
        }
        catch (ZipException e) {
            void var1_2;
            throw new IOException(var1_2.getMessage());
        }
        return new RandomAccessFile((String)var1_1, "r");
    }

    /*
     * WARNING - void declaration
     */
    private static void closeStreams(InputStream is, OutputStream os) throws ZipException {
        block16: {
            try {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    IOException e = iOException;
                    if (FieldAttributes.isStringNotNullAndNotEmpty(iOException.getMessage()) && e.getMessage().indexOf(" - Wrong Password?") >= 0) {
                        IOException iOException2;
                        throw new ZipException(iOException2.getMessage());
                    }
                    try {
                        if (os != null) {
                            os.close();
                            return;
                        }
                        break block16;
                    }
                    catch (IOException iOException3) {
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (os != null) {
                    void var1_2;
                    var1_2.close();
                    return;
                }
            }
            catch (IOException iOException) {}
        }
    }
}

