/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import com.google.gson.ExclusionStrategy;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.lingala.zip4j.crypto.AESDecrypter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.BaseInputStream;
import net.lingala.zip4j.unzip.UnzipEngine;

public class PartInputStream
extends BaseInputStream {
    private RandomAccessFile raf;
    private long bytesRead;
    private long length;
    private UnzipEngine unzipEngine;
    private ExclusionStrategy decrypter$71a6d55f;
    private byte[] oneByteBuff = new byte[1];
    private byte[] aesBlockByte = new byte[16];
    private int aesBytesReturned = 0;
    private boolean isAESEncryptedFile = false;
    private int count = -1;

    /*
     * WARNING - void declaration
     */
    public PartInputStream(RandomAccessFile raf, long len, UnzipEngine unzipEngine) {
        void var2_2;
        void var1_1;
        this.raf = var1_1;
        this.unzipEngine = unzipEngine;
        this.decrypter$71a6d55f = unzipEngine.decrypter$71a6d55f;
        this.bytesRead = 0L;
        this.length = var2_2;
        this.isAESEncryptedFile = unzipEngine.fileHeader.isEncrypted && unzipEngine.fileHeader.encryptionMethod == 99;
    }

    /*
     * WARNING - void declaration
     */
    public int available() {
        void var1_1;
        long amount = this.length - this.bytesRead;
        if (amount > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)var1_1;
    }

    public int read() throws IOException {
        if (this.bytesRead >= this.length) {
            return -1;
        }
        if (this.isAESEncryptedFile) {
            if (this.aesBytesReturned == 0 || this.aesBytesReturned == 16) {
                if (this.read(this.aesBlockByte) == -1) {
                    return -1;
                }
                this.aesBytesReturned = 0;
            }
            return this.aesBlockByte[this.aesBytesReturned++] & 0xFF;
        }
        if (this.read(this.oneByteBuff, 0, 1) == -1) {
            return -1;
        }
        return this.oneByteBuff[0] & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public int read(byte[] b) throws IOException {
        void var1_1;
        return this.read(b, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if ((long)len > this.length - this.bytesRead && (len = (int)(this.length - this.bytesRead)) == 0) {
            this.checkAndReadAESMacBytes();
            return -1;
        }
        if (this.unzipEngine.decrypter$71a6d55f instanceof AESDecrypter && this.bytesRead + (long)len < this.length && len % 16 != 0) {
            len -= len % 16;
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.count = this.raf.read(b, off, len);
            if (this.count < len && this.unzipEngine.zipModel.splitArchive) {
                int newlyRead;
                this.raf.close();
                this.raf = this.unzipEngine.startNextSplitFile();
                if (this.count < 0) {
                    this.count = 0;
                }
                if ((newlyRead = this.raf.read(b, this.count, len - this.count)) > 0) {
                    void var3_3;
                    this.count += var3_3;
                }
            }
        }
        if (this.count > 0) {
            if (this.decrypter$71a6d55f != null) {
                try {
                    void var2_2;
                    void var1_1;
                    this.decrypter$71a6d55f.decryptData((byte[])var1_1, (int)var2_2, this.count);
                }
                catch (ZipException e) {
                    throw new IOException(e.getMessage());
                }
            }
            this.bytesRead += (long)this.count;
        }
        if (this.bytesRead >= this.length) {
            this.checkAndReadAESMacBytes();
        }
        return this.count;
    }

    /*
     * WARNING - void declaration
     */
    protected final void checkAndReadAESMacBytes() throws IOException {
        if (this.isAESEncryptedFile && this.decrypter$71a6d55f != null && this.decrypter$71a6d55f instanceof AESDecrypter) {
            void var1_1;
            if (((AESDecrypter)this.decrypter$71a6d55f).storedMac != null) {
                return;
            }
            byte[] macBytes = new byte[10];
            int readLen = this.raf.read(macBytes);
            if (readLen != 10) {
                if (this.unzipEngine.zipModel.splitArchive) {
                    void var2_2;
                    this.raf.close();
                    this.raf = this.unzipEngine.startNextSplitFile();
                    this.raf.read(macBytes, readLen, 10 - var2_2);
                } else {
                    throw new IOException("Error occured while reading stored AES authentication bytes");
                }
            }
            ((AESDecrypter)this.unzipEngine.decrypter$71a6d55f).storedMac = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long skip(long amount) throws IOException {
        void var1_1;
        if (amount < 0L) {
            throw new IllegalArgumentException();
        }
        if (amount > this.length - this.bytesRead) {
            amount = this.length - this.bytesRead;
        }
        this.bytesRead += amount;
        return (long)var1_1;
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public UnzipEngine getUnzipEngine() {
        return this.unzipEngine;
    }
}

