/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import com.google.gson.ExclusionStrategy;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.LocalFileHeader;

public final class AESDecrypter
implements ExclusionStrategy {
    private LocalFileHeader localFileHeader;
    public int SALT_LENGTH;
    public byte[] storedMac;

    public AESDecrypter(LocalFileHeader localFileHeader) throws ZipException {
        AESDecrypter aESDecrypter;
        if (localFileHeader == null) {
            throw new ZipException("one of the input parameters is null in AESDecryptor Constructor");
        }
        this.localFileHeader = aESDecrypter;
        this.storedMac = null;
        aESDecrypter = this;
        if (aESDecrypter.localFileHeader == null) {
            throw new ZipException("invalid file header in init method of AESDecryptor");
        }
        AESExtraDataRecord aESExtraDataRecord = aESDecrypter.localFileHeader.aesExtraDataRecord;
        if (aESExtraDataRecord == null) {
            throw new ZipException("invalid aes extra data record - in init method of AESDecryptor");
        }
        switch (aESExtraDataRecord.aesStrength) {
            case 1: {
                aESDecrypter.SALT_LENGTH = 8;
                break;
            }
            case 2: {
                aESDecrypter.SALT_LENGTH = 12;
                break;
            }
            case 3: {
                aESDecrypter.SALT_LENGTH = 16;
                break;
            }
            default: {
                throw new ZipException("invalid aes key strength for file: " + aESDecrypter.localFileHeader.fileName);
            }
        }
        throw new ZipException("empty or null password provided for AES Decryptor");
    }

    public final int decryptData(byte[] buff, int start, int len) throws ZipException {
        throw new ZipException("AES not initialized properly");
    }
}

