/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;

public final class TypeAdapters {
    private static TypeAdapter<Class> CLASS = new TypeAdapter<Class>(){}.nullSafe();
    public static final TypeAdapterFactory CLASS_FACTORY = TypeAdapters.newFactory(Class.class, CLASS);
    private static TypeAdapter<BitSet> BIT_SET = new TypeAdapter<BitSet>(){
        private static /* synthetic */ int[] $SWITCH_TABLE$com$google$gson$stream$JsonToken;

        private static BitSet read(JsonReader jsonReader) throws IOException {
            BitSet bitSet = new BitSet();
            jsonReader.beginArray();
            int n = 0;
            JsonToken jsonToken = jsonReader.peek();
            while (jsonToken != JsonToken.END_ARRAY) {
                boolean bl;
                switch (2.$SWITCH_TABLE$com$google$gson$stream$JsonToken()[jsonToken.ordinal()]) {
                    case 7: {
                        bl = jsonReader.nextInt() != 0;
                        break;
                    }
                    case 8: {
                        bl = jsonReader.nextBoolean();
                        break;
                    }
                    case 6: {
                        String string = jsonReader.nextString();
                        try {
                            bl = Integer.parseInt(string) != 0;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new JsonSyntaxException("Error: Expecting: bitset number value (1, 0), Found: " + string);
                        }
                    }
                    default: {
                        throw new JsonSyntaxException("Invalid bitset value type: " + (Object)((Object)jsonToken));
                    }
                }
                if (bl) {
                    bitSet.set(n);
                }
                ++n;
                jsonToken = jsonReader.peek();
            }
            jsonReader.endArray();
            return bitSet;
        }

        private static /* synthetic */ int[] $SWITCH_TABLE$com$google$gson$stream$JsonToken() {
            if ($SWITCH_TABLE$com$google$gson$stream$JsonToken != null) {
                return $SWITCH_TABLE$com$google$gson$stream$JsonToken;
            }
            JsonToken.values();
            int[] nArray = new int[10];
            try {
                nArray[JsonToken.BEGIN_ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.BEGIN_OBJECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.BOOLEAN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.END_ARRAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.END_DOCUMENT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.END_OBJECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.NAME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.NULL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.NUMBER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.STRING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$com$google$gson$stream$JsonToken = nArray;
            return nArray;
        }
    }.nullSafe();
    public static final TypeAdapterFactory BIT_SET_FACTORY = TypeAdapters.newFactory(BitSet.class, BIT_SET);
    private static TypeAdapter<Boolean> BOOLEAN = new TypeAdapter<Boolean>(){};
    public static final TypeAdapter<Boolean> BOOLEAN_AS_STRING = new TypeAdapter<Boolean>(){};
    public static final TypeAdapterFactory BOOLEAN_FACTORY = TypeAdapters.newFactory(Boolean.TYPE, Boolean.class, BOOLEAN);
    private static TypeAdapter<Number> BYTE = new TypeAdapter<Number>(){

        private static Number read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return (byte)jsonReader.nextInt();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }
    };
    public static final TypeAdapterFactory BYTE_FACTORY = TypeAdapters.newFactory(Byte.TYPE, Byte.class, BYTE);
    private static TypeAdapter<Number> SHORT = new TypeAdapter<Number>(){

        private static Number read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return (short)jsonReader.nextInt();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }
    };
    public static final TypeAdapterFactory SHORT_FACTORY = TypeAdapters.newFactory(Short.TYPE, Short.class, SHORT);
    private static TypeAdapter<Number> INTEGER = new TypeAdapter<Number>(){

        private static Number read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return jsonReader.nextInt();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }
    };
    public static final TypeAdapterFactory INTEGER_FACTORY = TypeAdapters.newFactory(Integer.TYPE, Integer.class, INTEGER);
    private static TypeAdapter<AtomicInteger> ATOMIC_INTEGER = new TypeAdapter<AtomicInteger>(){

        private static AtomicInteger read(JsonReader jsonReader) throws IOException {
            try {
                return new AtomicInteger(jsonReader.nextInt());
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }
    }.nullSafe();
    public static final TypeAdapterFactory ATOMIC_INTEGER_FACTORY = TypeAdapters.newFactory(AtomicInteger.class, ATOMIC_INTEGER);
    private static TypeAdapter<AtomicBoolean> ATOMIC_BOOLEAN = new TypeAdapter<AtomicBoolean>(){}.nullSafe();
    public static final TypeAdapterFactory ATOMIC_BOOLEAN_FACTORY = TypeAdapters.newFactory(AtomicBoolean.class, ATOMIC_BOOLEAN);
    private static TypeAdapter<AtomicIntegerArray> ATOMIC_INTEGER_ARRAY = new TypeAdapter<AtomicIntegerArray>(){

        private static AtomicIntegerArray read(JsonReader object) throws IOException {
            int n;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ((JsonReader)object).beginArray();
            while (((JsonReader)object).hasNext()) {
                try {
                    n = ((JsonReader)object).nextInt();
                    arrayList.add(n);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
            }
            ((JsonReader)object).endArray();
            n = arrayList.size();
            object = new AtomicIntegerArray(n);
            int n2 = 0;
            while (n2 < n) {
                ((AtomicIntegerArray)object).set(n2, (Integer)arrayList.get(n2));
                ++n2;
            }
            return object;
        }
    }.nullSafe();
    public static final TypeAdapterFactory ATOMIC_INTEGER_ARRAY_FACTORY = TypeAdapters.newFactory(AtomicIntegerArray.class, ATOMIC_INTEGER_ARRAY);
    public static final TypeAdapter<Number> LONG = new TypeAdapter<Number>(){

        private static Number read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return jsonReader.nextLong();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }
    };
    private static TypeAdapter<Number> NUMBER;
    public static final TypeAdapterFactory NUMBER_FACTORY;
    private static TypeAdapter<Character> CHARACTER;
    public static final TypeAdapterFactory CHARACTER_FACTORY;
    private static TypeAdapter<String> STRING;
    public static final TypeAdapter<BigDecimal> BIG_DECIMAL;
    public static final TypeAdapter<BigInteger> BIG_INTEGER;
    public static final TypeAdapterFactory STRING_FACTORY;
    private static TypeAdapter<StringBuilder> STRING_BUILDER;
    public static final TypeAdapterFactory STRING_BUILDER_FACTORY;
    private static TypeAdapter<StringBuffer> STRING_BUFFER;
    public static final TypeAdapterFactory STRING_BUFFER_FACTORY;
    private static TypeAdapter<URL> URL;
    public static final TypeAdapterFactory URL_FACTORY;
    private static TypeAdapter<URI> URI;
    public static final TypeAdapterFactory URI_FACTORY;
    private static TypeAdapter<InetAddress> INET_ADDRESS;
    public static final TypeAdapterFactory INET_ADDRESS_FACTORY;
    private static TypeAdapter<UUID> UUID;
    public static final TypeAdapterFactory UUID_FACTORY;
    private static TypeAdapter<Currency> CURRENCY;
    public static final TypeAdapterFactory CURRENCY_FACTORY;
    public static final TypeAdapterFactory TIMESTAMP_FACTORY;
    private static TypeAdapter<Calendar> CALENDAR;
    public static final TypeAdapterFactory CALENDAR_FACTORY;
    private static TypeAdapter<Locale> LOCALE;
    public static final TypeAdapterFactory LOCALE_FACTORY;
    public static final TypeAdapter<JsonElement> JSON_ELEMENT;
    public static final TypeAdapterFactory JSON_ELEMENT_FACTORY;
    public static final TypeAdapterFactory ENUM_FACTORY;

    static {
        new TypeAdapter<Number>(){};
        new TypeAdapter<Number>(){};
        NUMBER = new TypeAdapter<Number>(){
            private static /* synthetic */ int[] $SWITCH_TABLE$com$google$gson$stream$JsonToken;

            private static /* synthetic */ int[] $SWITCH_TABLE$com$google$gson$stream$JsonToken() {
                if ($SWITCH_TABLE$com$google$gson$stream$JsonToken != null) {
                    return $SWITCH_TABLE$com$google$gson$stream$JsonToken;
                }
                JsonToken.values();
                int[] nArray = new int[10];
                try {
                    nArray[JsonToken.BEGIN_ARRAY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.BEGIN_OBJECT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.BOOLEAN.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.END_ARRAY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.END_DOCUMENT.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.END_OBJECT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.NAME.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.NULL.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.NUMBER.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.STRING.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $SWITCH_TABLE$com$google$gson$stream$JsonToken = nArray;
                return nArray;
            }
        };
        NUMBER_FACTORY = TypeAdapters.newFactory(Number.class, NUMBER);
        CHARACTER = new TypeAdapter<Character>(){};
        CHARACTER_FACTORY = TypeAdapters.newFactory(Character.TYPE, Character.class, CHARACTER);
        STRING = new TypeAdapter<String>(){};
        BIG_DECIMAL = new TypeAdapter<BigDecimal>(){

            private static BigDecimal read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    return new BigDecimal(jsonReader.nextString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
            }
        };
        BIG_INTEGER = new TypeAdapter<BigInteger>(){

            private static BigInteger read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    return new BigInteger(jsonReader.nextString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
            }
        };
        STRING_FACTORY = TypeAdapters.newFactory(String.class, STRING);
        STRING_BUILDER = new TypeAdapter<StringBuilder>(){};
        STRING_BUILDER_FACTORY = TypeAdapters.newFactory(StringBuilder.class, STRING_BUILDER);
        STRING_BUFFER = new TypeAdapter<StringBuffer>(){};
        STRING_BUFFER_FACTORY = TypeAdapters.newFactory(StringBuffer.class, STRING_BUFFER);
        URL = new TypeAdapter<URL>(){};
        URL_FACTORY = TypeAdapters.newFactory(URL.class, URL);
        URI = new TypeAdapter<URI>(){

            private static URI read(JsonReader object) throws IOException {
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                try {
                    object = ((JsonReader)object).nextString();
                    if ("null".equals(object)) {
                        return null;
                    }
                    return new URI((String)object);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new JsonIOException(uRISyntaxException);
                }
            }
        };
        URI_FACTORY = TypeAdapters.newFactory(URI.class, URI);
        INET_ADDRESS = new TypeAdapter<InetAddress>(){};
        INET_ADDRESS_FACTORY = TypeAdapters.newTypeHierarchyFactory(InetAddress.class, INET_ADDRESS);
        UUID = new TypeAdapter<UUID>(){};
        UUID_FACTORY = TypeAdapters.newFactory(UUID.class, UUID);
        CURRENCY = new TypeAdapter<Currency>(){}.nullSafe();
        CURRENCY_FACTORY = TypeAdapters.newFactory(Currency.class, CURRENCY);
        TIMESTAMP_FACTORY = new TypeAdapterFactory(){

            @Override
            public final <T> TypeAdapter<T> create(Gson object, TypeToken<T> typeToken) {
                if (typeToken.rawType != Timestamp.class) {
                    return null;
                }
                object = ((Gson)object).getAdapter(Date.class);
                return new TypeAdapter<Timestamp>((TypeAdapter)object){
                    private final /* synthetic */ TypeAdapter val$dateTypeAdapter;
                    {
                        this.val$dateTypeAdapter = typeAdapter;
                    }
                };
            }
        };
        CALENDAR = new TypeAdapter<Calendar>(){};
        final TypeAdapter<Calendar> typeAdapter = CALENDAR;
        final Class<GregorianCalendar> clazz = GregorianCalendar.class;
        final Class<Calendar> clazz2 = Calendar.class;
        CALENDAR_FACTORY = new TypeAdapterFactory(){

            @Override
            public final <T> TypeAdapter<T> create(Gson clazz3, TypeToken<T> typeToken) {
                clazz3 = typeToken.rawType;
                if (clazz3 == clazz2 || clazz3 == clazz) {
                    return typeAdapter;
                }
                return null;
            }

            public final String toString() {
                return "Factory[type=" + clazz2.getName() + "+" + clazz.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
        LOCALE = new TypeAdapter<Locale>(){};
        LOCALE_FACTORY = TypeAdapters.newFactory(Locale.class, LOCALE);
        JSON_ELEMENT = new TypeAdapter<JsonElement>(){
            private static /* synthetic */ int[] $SWITCH_TABLE$com$google$gson$stream$JsonToken;

            @Override
            private JsonElement read(JsonReader object) throws IOException {
                switch (29.$SWITCH_TABLE$com$google$gson$stream$JsonToken()[((JsonReader)object).peek().ordinal()]) {
                    case 6: {
                        return new JsonPrimitive(((JsonReader)object).nextString());
                    }
                    case 7: {
                        object = ((JsonReader)object).nextString();
                        return new JsonPrimitive(new LazilyParsedNumber((String)object));
                    }
                    case 8: {
                        return new JsonPrimitive(((JsonReader)object).nextBoolean());
                    }
                    case 9: {
                        ((JsonReader)object).nextNull();
                        return JsonNull.INSTANCE;
                    }
                    case 1: {
                        JsonArray jsonArray = new JsonArray();
                        ((JsonReader)object).beginArray();
                        while (((JsonReader)object).hasNext()) {
                            JsonElement jsonElement = this.read((JsonReader)object);
                            JsonArray jsonArray2 = jsonArray;
                            if (jsonElement == null) {
                                jsonElement = JsonNull.INSTANCE;
                            }
                            jsonArray2.elements.add(jsonElement);
                        }
                        ((JsonReader)object).endArray();
                        return jsonArray;
                    }
                    case 3: {
                        JsonObject jsonObject = new JsonObject();
                        ((JsonReader)object).beginObject();
                        while (((JsonReader)object).hasNext()) {
                            JsonElement jsonElement = this.read((JsonReader)object);
                            String string = ((JsonReader)object).nextName();
                            JsonObject jsonObject2 = jsonObject;
                            if (jsonElement == null) {
                                jsonElement = JsonNull.INSTANCE;
                            }
                            jsonObject2.members.put(string, jsonElement);
                        }
                        ((JsonReader)object).endObject();
                        return jsonObject;
                    }
                }
                throw new IllegalArgumentException();
            }

            @Override
            private void write(JsonWriter jsonWriter, JsonElement object2) throws IOException {
                if (object2 == null || object2 instanceof JsonNull) {
                    jsonWriter.nullValue();
                    return;
                }
                if (object2 instanceof JsonPrimitive) {
                    Object object = object2;
                    if (!(object instanceof JsonPrimitive)) {
                        throw new IllegalStateException("Not a JSON Primitive: " + object);
                    }
                    JsonPrimitive jsonPrimitive = (JsonPrimitive)object;
                    if (jsonPrimitive.value instanceof Number) {
                        jsonWriter.value(jsonPrimitive.getAsNumber());
                        return;
                    }
                    if (jsonPrimitive.value instanceof Boolean) {
                        jsonWriter.value(jsonPrimitive.getAsBoolean());
                        return;
                    }
                    jsonWriter.value(jsonPrimitive.getAsString());
                    return;
                }
                if (object2 instanceof JsonArray) {
                    jsonWriter.beginArray();
                    Object object = object2;
                    if (!(object instanceof JsonArray)) {
                        throw new IllegalStateException("Not a JSON Array: " + object);
                    }
                    for (JsonElement jsonElement : (JsonArray)object) {
                        this.write(jsonWriter, jsonElement);
                    }
                    jsonWriter.endArray();
                    return;
                }
                if (object2 instanceof JsonObject) {
                    jsonWriter.beginObject();
                    Object object = object2;
                    if (!(object instanceof JsonObject)) {
                        throw new IllegalStateException("Not a JSON Object: " + object);
                    }
                    for (Map.Entry<String, JsonElement> entry : ((JsonObject)object).members.entrySet()) {
                        jsonWriter.name(entry.getKey());
                        this.write(jsonWriter, entry.getValue());
                    }
                    jsonWriter.endObject();
                    return;
                }
                throw new IllegalArgumentException("Couldn't write " + object2.getClass());
            }

            private static /* synthetic */ int[] $SWITCH_TABLE$com$google$gson$stream$JsonToken() {
                if ($SWITCH_TABLE$com$google$gson$stream$JsonToken != null) {
                    return $SWITCH_TABLE$com$google$gson$stream$JsonToken;
                }
                JsonToken.values();
                int[] nArray = new int[10];
                try {
                    nArray[JsonToken.BEGIN_ARRAY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.BEGIN_OBJECT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.BOOLEAN.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.END_ARRAY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.END_DOCUMENT.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.END_OBJECT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.NAME.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.NULL.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.NUMBER.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[JsonToken.STRING.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $SWITCH_TABLE$com$google$gson$stream$JsonToken = nArray;
                return nArray;
            }
        };
        JSON_ELEMENT_FACTORY = TypeAdapters.newTypeHierarchyFactory(JsonElement.class, JSON_ELEMENT);
        ENUM_FACTORY = new TypeAdapterFactory(){

            @Override
            public final <T> TypeAdapter<T> create(Gson clazz, TypeToken<T> typeToken) {
                clazz = typeToken.rawType;
                if (!Enum.class.isAssignableFrom(clazz) || clazz == Enum.class) {
                    return null;
                }
                if (!clazz.isEnum()) {
                    clazz = clazz.getSuperclass();
                }
                return new EnumTypeAdapter(clazz);
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> clazz, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (typeToken.rawType == clazz) {
                    return typeAdapter;
                }
                return null;
            }

            public final String toString() {
                return "Factory[type=" + clazz.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> clazz, final Class<TT> clazz2, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public final <T> TypeAdapter<T> create(Gson clazz3, TypeToken<T> typeToken) {
                clazz3 = typeToken.rawType;
                if (clazz3 == clazz || clazz3 == clazz2) {
                    return typeAdapter;
                }
                return null;
            }

            public final String toString() {
                return "Factory[type=" + clazz2.getName() + "+" + clazz.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    private static <T1> TypeAdapterFactory newTypeHierarchyFactory(final Class<T1> clazz, final TypeAdapter<T1> typeAdapter) {
        return new TypeAdapterFactory(){

            public final <T2> TypeAdapter<T2> create(final Gson clazz2, TypeToken<T2> typeToken) {
                clazz2 = typeToken.rawType;
                if (!clazz.isAssignableFrom(clazz2)) {
                    return null;
                }
                return new TypeAdapter<T1>(){

                    @Override
                    public final void write(JsonWriter jsonWriter, T1 T1) throws IOException {
                        typeAdapter.write(jsonWriter, T1);
                    }

                    @Override
                    public final T1 read(JsonReader jsonReader) throws IOException {
                        if ((jsonReader = typeAdapter.read(jsonReader)) != null && !clazz2.isInstance(jsonReader)) {
                            throw new JsonSyntaxException("Expected a " + clazz2.getName() + " but was " + jsonReader.getClass().getName());
                        }
                        return jsonReader;
                    }
                };
            }

            public final String toString() {
                return "Factory[typeHierarchy=" + clazz.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    static final class EnumTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Map<String, T> nameToConstant = new HashMap<String, T>();
        private final Map<T, String> constantToName = new HashMap<T, String>();

        public EnumTypeAdapter(Class<T> clazz) {
            try {
                Enum[] enumArray = (Enum[])clazz.getEnumConstants();
                int n = enumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Enum enum_ = enumArray[n2];
                    String string = enum_.name();
                    Object object = clazz.getField(string).getAnnotation(SerializedName.class);
                    if (object != null) {
                        string = object.value();
                        String[] stringArray = object.alternate();
                        int n3 = stringArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            object = stringArray[n4];
                            this.nameToConstant.put((String)object, enum_);
                            ++n4;
                        }
                    }
                    this.nameToConstant.put(string, enum_);
                    this.constantToName.put(enum_, string);
                    ++n2;
                }
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new AssertionError((Object)noSuchFieldException);
            }
        }
    }
}

