/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Since;
import com.google.gson.annotations.Until;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final ExclusionStrategy fieldNamingPolicy$348657ce;
    private final Excluder excluder;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, ExclusionStrategy exclusionStrategy, Excluder excluder) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy$348657ce = exclusionStrategy;
        this.excluder = excluder;
    }

    private boolean excludeField(Field list, boolean bl) {
        Excluder excluder = this.excluder;
        if (!excluder.excludeClass(((Field)((Object)list)).getType(), bl)) {
            boolean bl2;
            boolean bl3 = bl;
            Object object = list;
            list = excluder;
            if ((((Excluder)((Object)list)).modifiers & ((Field)object).getModifiers()) != 0) {
                bl2 = true;
            } else if (((Excluder)((Object)list)).version != -1.0 && !((Excluder)((Object)list)).isValidVersion(((Field)object).getAnnotation(Since.class), ((Field)object).getAnnotation(Until.class))) {
                bl2 = true;
            } else if (((Field)object).isSynthetic()) {
                bl2 = true;
            } else if (!((Excluder)((Object)list)).serializeInnerClasses && Excluder.isInnerClass(((Field)object).getType())) {
                bl2 = true;
            } else if (Excluder.isAnonymousOrLocal(((Field)object).getType())) {
                bl2 = true;
            } else {
                list = bl3 ? ((Excluder)((Object)list)).serializationStrategies : ((Excluder)((Object)list)).deserializationStrategies;
                if (!list.isEmpty()) {
                    new FieldAttributes((Field)object);
                    object = list.iterator();
                    while (object.hasNext()) {
                        if (!((ExclusionStrategy)object.next()).shouldSkipField$6e8224bb()) continue;
                        bl2 = true;
                        break;
                    }
                } else {
                    bl2 = false;
                }
            }
            if (!bl2) {
                return true;
            }
        }
        return false;
    }

    private List<String> getFieldNames(Field object) {
        String[] stringArray = ((Field)object).getAnnotation(SerializedName.class);
        if (stringArray == null) {
            return Collections.singletonList(this.fieldNamingPolicy$348657ce.translateName((Field)object));
        }
        object = stringArray.value();
        if ((stringArray = stringArray.alternate()).length == 0) {
            return Collections.singletonList(object);
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + 1);
        arrayList.add((String)object);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray2[n2];
            arrayList.add((String)object);
            ++n2;
        }
        return arrayList;
    }

    @Override
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Class clazz = typeToken.rawType;
        if (!Object.class.isAssignableFrom(clazz)) {
            return null;
        }
        ExclusionStrategy<T> exclusionStrategy = this.constructorConstructor.get$7d5d43a5(typeToken);
        return new Adapter<T>(exclusionStrategy, this.getBoundFields(gson, typeToken, clazz));
    }

    private Map<String, BoundField> getBoundFields(Gson gson, TypeToken<?> typeToken, Class<?> clazz) {
        LinkedHashMap<String, BoundField> linkedHashMap = new LinkedHashMap<String, BoundField>();
        if (clazz.isInterface()) {
            return linkedHashMap;
        }
        Type type = typeToken.type;
        while (clazz != Object.class) {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                boolean bl = this.excludeField(field, true);
                boolean bl2 = this.excludeField(field, false);
                if (bl || bl2) {
                    field.setAccessible(true);
                    Type type2 = $Gson$Types.resolve(typeToken.type, clazz, field.getGenericType());
                    List<String> list = this.getFieldNames(field);
                    Object object = null;
                    int n3 = 0;
                    int n4 = list.size();
                    while (n3 < n4) {
                        boolean bl3;
                        Object object2 = list.get(n3);
                        if (n3 != 0) {
                            bl = false;
                        }
                        boolean bl4 = bl2;
                        boolean bl5 = bl;
                        final TypeToken<?> typeToken2 = TypeToken.get(type2);
                        String string = object2;
                        final Field field2 = field;
                        final Gson gson2 = gson;
                        Object object3 = this;
                        final boolean bl6 = Primitives.isPrimitive(typeToken2.rawType);
                        JsonAdapter jsonAdapter = field2.getAnnotation(JsonAdapter.class);
                        final TypeAdapter<?> typeAdapter = null;
                        if (jsonAdapter != null) {
                            typeAdapter = JsonAdapterAnnotationTypeAdapterFactory.getTypeAdapter(((ReflectiveTypeAdapterFactory)object3).constructorConstructor, gson2, typeToken2, jsonAdapter);
                        }
                        boolean bl7 = bl3 = typeAdapter != null;
                        if (typeAdapter == null) {
                            typeAdapter = gson2.getAdapter(typeToken2);
                        }
                        object3 = new BoundField(string, bl5, bl4){

                            @Override
                            final void write(JsonWriter jsonWriter, Object object) throws IOException, IllegalAccessException {
                                object = field2.get(object);
                                (bl3 ? typeAdapter : new TypeAdapterRuntimeTypeWrapper(gson2, typeAdapter, typeToken2.type)).write(jsonWriter, object);
                            }

                            @Override
                            final void read(JsonReader jsonReader, Object object) throws IOException, IllegalAccessException {
                                if ((jsonReader = typeAdapter.read(jsonReader)) != null || !bl6) {
                                    field2.set(object, jsonReader);
                                }
                            }

                            @Override
                            public final boolean writeField(Object object) throws IOException, IllegalAccessException {
                                if (!this.serialized) {
                                    return false;
                                }
                                return field2.get(object) != object;
                            }
                        };
                        object2 = linkedHashMap.put((String)object2, (BoundField)object3);
                        if (object == null) {
                            object = object2;
                        }
                        ++n3;
                    }
                    if (object != null) {
                        throw new IllegalArgumentException(type + " declares multiple JSON fields named " + ((BoundField)object).name);
                    }
                }
                ++n2;
            }
            typeToken = TypeToken.get($Gson$Types.resolve(typeToken.type, clazz, clazz.getGenericSuperclass()));
            clazz = typeToken.rawType;
        }
        return linkedHashMap;
    }

    public static final class Adapter<T>
    extends TypeAdapter<T> {
        private final ExclusionStrategy<T> constructor$1fc97f8a;
        private final Map<String, BoundField> boundFields;

        Adapter(ExclusionStrategy<T> exclusionStrategy, Map<String, BoundField> map) {
            this.constructor$1fc97f8a = exclusionStrategy;
            this.boundFields = map;
        }

        @Override
        public final T read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            T t = this.constructor$1fc97f8a.construct();
            try {
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    Object object = jsonReader.nextName();
                    if ((object = this.boundFields.get(object)) == null || !((BoundField)object).deserialized) {
                        jsonReader.skipValue();
                        continue;
                    }
                    ((BoundField)object).read(jsonReader, t);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw new JsonSyntaxException(illegalStateException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            jsonReader.endObject();
            return t;
        }

        @Override
        public final void write(JsonWriter jsonWriter, T t) throws IOException {
            if (t == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            try {
                for (BoundField boundField : this.boundFields.values()) {
                    if (!boundField.writeField(t)) continue;
                    jsonWriter.name(boundField.name);
                    boundField.write(jsonWriter, t);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            jsonWriter.endObject();
        }
    }

    static abstract class BoundField {
        final String name;
        final boolean serialized;
        final boolean deserialized;

        protected BoundField(String string, boolean bl, boolean bl2) {
            this.name = string;
            this.serialized = bl;
            this.deserialized = bl2;
        }

        abstract boolean writeField(Object var1) throws IOException, IllegalAccessException;

        abstract void write(JsonWriter var1, Object var2) throws IOException, IllegalAccessException;

        abstract void read(JsonReader var1, Object var2) throws IOException, IllegalAccessException;
    }
}

