/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;

public final class DateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (typeToken.rawType == Date.class) {
                return new DateTypeAdapter();
            }
            return null;
        }
    };
    private final DateFormat enUsFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private final DateFormat localFormat = DateFormat.getDateTimeInstance(2, 2);

    private synchronized Date deserializeToDate(String string) {
        try {
            return this.localFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                return this.enUsFormat.parse(string);
            }
            catch (ParseException parseException2) {
                try {
                    return ISO8601Utils.parse(string, new ParsePosition(0));
                }
                catch (ParseException parseException3) {
                    throw new JsonSyntaxException(string, parseException3);
                }
            }
        }
    }

    @Override
    private synchronized void write(JsonWriter jsonWriter, Date object) throws IOException {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        object = this.enUsFormat.format((Date)object);
        jsonWriter.value((String)object);
    }
}

