/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import com.google.gson.ExclusionStrategy;
import net.lingala.zip4j.crypto.engine.ZipCryptoEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;

public final class StandardDecrypter
implements ExclusionStrategy {
    private FileHeader fileHeader;
    private byte[] crc = new byte[4];
    private ZipCryptoEngine zipCryptoEngine;

    public StandardDecrypter(FileHeader fileHeader) throws ZipException {
        StandardDecrypter standardDecrypter;
        if (fileHeader == null) {
            throw new ZipException("one of more of the input parameters were null in StandardDecryptor");
        }
        this.fileHeader = standardDecrypter;
        this.zipCryptoEngine = new ZipCryptoEngine();
        standardDecrypter = this;
        byte[] byArray = standardDecrypter.fileHeader.crcBuff;
        standardDecrypter.crc[3] = byArray[3];
        standardDecrypter.crc[2] = (byte)(byArray[3] >> 8);
        standardDecrypter.crc[1] = (byte)(byArray[3] >> 16);
        standardDecrypter.crc[0] = byArray[3] >> 24;
        if (standardDecrypter.crc[2] > 0 || standardDecrypter.crc[1] > 0 || standardDecrypter.crc[0] > 0) {
            throw new IllegalStateException("Invalid CRC in File Header");
        }
        throw new ZipException("Wrong password!", 0);
    }

    /*
     * WARNING - void declaration
     */
    public final int decryptData(byte[] buff, int start, int len) throws ZipException {
        if (start < 0 || len < 0) {
            throw new ZipException("one of the input parameters were null in standard decrpyt data");
        }
        try {
            void var3_3;
            int i = start;
            while (i < start + len) {
                int n = this.zipCryptoEngine.keys[2] | 2;
                int val = (buff[i] & 0xFF ^ (byte)(n * (n ^ 1) >>> 8)) & 0xFF;
                byte by = (byte)val;
                ZipCryptoEngine zipCryptoEngine = this.zipCryptoEngine;
                zipCryptoEngine.keys[0] = ZipCryptoEngine.crc32(zipCryptoEngine.keys[0], by);
                zipCryptoEngine.keys[1] = zipCryptoEngine.keys[1] + (zipCryptoEngine.keys[0] & 0xFF);
                zipCryptoEngine.keys[1] = zipCryptoEngine.keys[1] * 134775813 + 1;
                zipCryptoEngine.keys[2] = ZipCryptoEngine.crc32(zipCryptoEngine.keys[2], zipCryptoEngine.keys[1] >> 24);
                buff[i] = (byte)val;
                ++i;
            }
            return (int)var3_3;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }
}

