/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.JsonPrimitive;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;

public class JsonReader
implements Closeable {
    private static final char[] NON_EXECUTE_PREFIX = ")]}'\n".toCharArray();
    private final Reader in;
    public boolean lenient = false;
    private final char[] buffer = new char[1024];
    private int pos = 0;
    private int limit = 0;
    private int lineNumber = 0;
    private int lineStart = 0;
    int peeked = 0;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String[] pathNames;
    private int[] pathIndices;

    static {
        JsonReaderInternalAccess.INSTANCE = new JsonReaderInternalAccess(){

            @Override
            public final void promoteNameToValue(JsonReader jsonReader) throws IOException {
                if (jsonReader instanceof JsonTreeReader) {
                    jsonReader = (JsonTreeReader)jsonReader;
                    ((JsonTreeReader)jsonReader).expect(JsonToken.NAME);
                    Map.Entry entry = (Map.Entry)((Iterator)((JsonTreeReader)jsonReader).peekStack()).next();
                    ((JsonTreeReader)jsonReader).push(entry.getValue());
                    ((JsonTreeReader)jsonReader).push(new JsonPrimitive((String)entry.getKey()));
                    return;
                }
                int n = jsonReader.peeked;
                if (n == 0) {
                    n = jsonReader.doPeek();
                }
                if (n == 13) {
                    jsonReader.peeked = 9;
                    return;
                }
                if (n == 12) {
                    jsonReader.peeked = 8;
                    return;
                }
                if (n == 14) {
                    jsonReader.peeked = 10;
                    return;
                }
                throw new IllegalStateException("Expected a name but was " + (Object)((Object)jsonReader.peek()) + jsonReader.locationString());
            }
        };
    }

    public JsonReader(Reader reader) {
        this.stack[this.stackSize++] = 6;
        this.pathNames = new String[32];
        this.pathIndices = new int[32];
        this.in = reader;
    }

    public void beginArray() throws IOException {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 3) {
            this.push(1);
            this.pathIndices[this.stackSize - 1] = 0;
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected BEGIN_ARRAY but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public void endArray() throws IOException {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 4) {
            --this.stackSize;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected END_ARRAY but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public void beginObject() throws IOException {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 1) {
            this.push(3);
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected BEGIN_OBJECT but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public void endObject() throws IOException {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 2) {
            --this.stackSize;
            this.pathNames[this.stackSize] = null;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            this.peeked = 0;
            return;
        }
        throw new IllegalStateException("Expected END_OBJECT but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public boolean hasNext() throws IOException {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        return n != 2 && n != 4;
    }

    public JsonToken peek() throws IOException {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        switch (n) {
            case 1: {
                return JsonToken.BEGIN_OBJECT;
            }
            case 2: {
                return JsonToken.END_OBJECT;
            }
            case 3: {
                return JsonToken.BEGIN_ARRAY;
            }
            case 4: {
                return JsonToken.END_ARRAY;
            }
            case 12: 
            case 13: 
            case 14: {
                return JsonToken.NAME;
            }
            case 5: 
            case 6: {
                return JsonToken.BOOLEAN;
            }
            case 7: {
                return JsonToken.NULL;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return JsonToken.STRING;
            }
            case 15: 
            case 16: {
                return JsonToken.NUMBER;
            }
            case 17: {
                return JsonToken.END_DOCUMENT;
            }
        }
        throw new AssertionError();
    }

    final int doPeek() throws IOException {
        int n;
        block49: {
            block51: {
                block50: {
                    block48: {
                        n = this.stack[this.stackSize - 1];
                        if (n != 1) break block48;
                        this.stack[this.stackSize - 1] = 2;
                        break block49;
                    }
                    if (n != 2) break block50;
                    switch (this.nextNonWhitespace(true)) {
                        case 93: {
                            this.peeked = 4;
                            return 4;
                        }
                        case 59: {
                            this.checkLenient();
                        }
                        case 44: {
                            break block49;
                        }
                        default: {
                            throw this.syntaxError("Unterminated array");
                        }
                    }
                }
                if (n == 3 || n == 5) {
                    this.stack[this.stackSize - 1] = 4;
                    if (n == 5) {
                        switch (this.nextNonWhitespace(true)) {
                            case 125: {
                                this.peeked = 2;
                                return 2;
                            }
                            case 59: {
                                this.checkLenient();
                            }
                            case 44: {
                                break;
                            }
                            default: {
                                throw this.syntaxError("Unterminated object");
                            }
                        }
                    }
                    int n2 = this.nextNonWhitespace(true);
                    switch (n2) {
                        case 34: {
                            this.peeked = 13;
                            return 13;
                        }
                        case 39: {
                            this.checkLenient();
                            this.peeked = 12;
                            return 12;
                        }
                        case 125: {
                            if (n != 5) {
                                this.peeked = 2;
                                return 2;
                            }
                            throw this.syntaxError("Expected name");
                        }
                    }
                    this.checkLenient();
                    --this.pos;
                    if (this.isLiteral((char)n2)) {
                        this.peeked = 14;
                        return 14;
                    }
                    throw this.syntaxError("Expected name");
                }
                if (n != 4) break block51;
                this.stack[this.stackSize - 1] = 5;
                switch (this.nextNonWhitespace(true)) {
                    case 58: {
                        break block49;
                    }
                    case 61: {
                        this.checkLenient();
                        if ((this.pos < this.limit || this.fillBuffer(1)) && this.buffer[this.pos] == '>') {
                            ++this.pos;
                        }
                        break block49;
                    }
                    default: {
                        throw this.syntaxError("Expected ':'");
                    }
                }
            }
            if (n == 6) {
                block47: {
                    if (this.lenient) {
                        JsonReader jsonReader = this;
                        jsonReader.nextNonWhitespace(true);
                        --jsonReader.pos;
                        if (jsonReader.pos + NON_EXECUTE_PREFIX.length <= jsonReader.limit || jsonReader.fillBuffer(NON_EXECUTE_PREFIX.length)) {
                            int n3 = 0;
                            while (n3 < NON_EXECUTE_PREFIX.length) {
                                if (jsonReader.buffer[jsonReader.pos + n3] == NON_EXECUTE_PREFIX[n3]) {
                                    ++n3;
                                    continue;
                                }
                                break block47;
                            }
                            jsonReader.pos += NON_EXECUTE_PREFIX.length;
                        }
                    }
                }
                this.stack[this.stackSize - 1] = 7;
            } else if (n == 7) {
                if (this.nextNonWhitespace(false) == -1) {
                    this.peeked = 17;
                    return 17;
                }
                this.checkLenient();
                --this.pos;
            } else if (n == 8) {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        switch (this.nextNonWhitespace(true)) {
            case 93: {
                if (n == 1) {
                    this.peeked = 4;
                    return 4;
                }
            }
            case 44: 
            case 59: {
                if (n == 1 || n == 2) {
                    this.checkLenient();
                    --this.pos;
                    this.peeked = 7;
                    return 7;
                }
                throw this.syntaxError("Unexpected value");
            }
            case 39: {
                this.checkLenient();
                this.peeked = 8;
                return 8;
            }
            case 34: {
                this.peeked = 9;
                return 9;
            }
            case 91: {
                this.peeked = 3;
                return 3;
            }
            case 123: {
                this.peeked = 1;
                return 1;
            }
        }
        --this.pos;
        n = this.peekKeyword();
        if (n != 0) {
            return n;
        }
        n = this.peekNumber();
        if (n != 0) {
            return n;
        }
        if (!this.isLiteral(this.buffer[this.pos])) {
            throw this.syntaxError("Expected value");
        }
        this.checkLenient();
        this.peeked = 10;
        return 10;
    }

    private int peekKeyword() throws IOException {
        int n;
        String string;
        String string2;
        char c = this.buffer[this.pos];
        if (c == 't' || c == 'T') {
            string2 = "true";
            string = "TRUE";
            n = 5;
        } else if (c == 'f' || c == 'F') {
            string2 = "false";
            string = "FALSE";
            n = 6;
        } else if (c == 'n' || c == 'N') {
            string2 = "null";
            string = "NULL";
            n = 7;
        } else {
            return 0;
        }
        int n2 = string2.length();
        int n3 = 1;
        while (n3 < n2) {
            if (this.pos + n3 >= this.limit && !this.fillBuffer(n3 + 1)) {
                return 0;
            }
            c = this.buffer[this.pos + n3];
            if (c != string2.charAt(n3) && c != string.charAt(n3)) {
                return 0;
            }
            ++n3;
        }
        if ((this.pos + n2 < this.limit || this.fillBuffer(n2 + 1)) && this.isLiteral(this.buffer[this.pos + n2])) {
            return 0;
        }
        this.pos += n2;
        this.peeked = n;
        return this.peeked;
    }

    private int peekNumber() throws IOException {
        char[] cArray = this.buffer;
        int n = this.pos;
        int n2 = this.limit;
        long l = 0L;
        boolean bl = false;
        boolean bl2 = true;
        int n3 = 0;
        int n4 = 0;
        block6: while (true) {
            if (n + n4 == n2) {
                if (n4 == 1024) {
                    return 0;
                }
                if (!this.fillBuffer(n4 + 1)) break;
                n = this.pos;
                n2 = this.limit;
            }
            char c = cArray[n + n4];
            switch (c) {
                case '-': {
                    if (n3 == 0) {
                        bl = true;
                        n3 = 1;
                        break;
                    }
                    if (n3 == 5) {
                        n3 = 6;
                        break;
                    }
                    return 0;
                }
                case '+': {
                    if (n3 == 5) {
                        n3 = 6;
                        break;
                    }
                    return 0;
                }
                case 'E': 
                case 'e': {
                    if (n3 == 2 || n3 == 4) {
                        n3 = 5;
                        break;
                    }
                    return 0;
                }
                case '.': {
                    if (n3 == 2) {
                        n3 = 3;
                        break;
                    }
                    return 0;
                }
                default: {
                    if (c < '0' || c > '9') {
                        if (!this.isLiteral(c)) break block6;
                        return 0;
                    }
                    if (n3 == 1 || n3 == 0) {
                        l = -(c - 48);
                        n3 = 2;
                        break;
                    }
                    if (n3 == 2) {
                        if (l == 0L) {
                            return 0;
                        }
                        long l2 = l * 10L - (long)(c - 48);
                        bl2 &= l > -922337203685477580L || l == -922337203685477580L && l2 < l;
                        l = l2;
                        break;
                    }
                    if (n3 == 3) {
                        n3 = 4;
                        break;
                    }
                    if (n3 != 5 && n3 != 6) break;
                    n3 = 7;
                }
            }
            ++n4;
        }
        if (!(n3 != 2 || !bl2 || l == Long.MIN_VALUE && !bl || l == 0L && bl)) {
            this.peekedLong = bl ? l : -l;
            this.pos += n4;
            this.peeked = 15;
            return 15;
        }
        if (n3 == 2 || n3 == 4 || n3 == 7) {
            this.peekedNumberLength = n4;
            this.peeked = 16;
            return 16;
        }
        return 0;
    }

    private boolean isLiteral(char c) throws IOException {
        switch (c) {
            case '#': 
            case '/': 
            case ';': 
            case '=': 
            case '\\': {
                this.checkLenient();
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    public String nextName() throws IOException {
        String string;
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 14) {
            string = this.nextUnquotedValue();
        } else if (n == 12) {
            string = this.nextQuotedValue('\'');
        } else if (n == 13) {
            string = this.nextQuotedValue('\"');
        } else {
            throw new IllegalStateException("Expected a name but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = string;
        return string;
    }

    public String nextString() throws IOException {
        String string;
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 10) {
            string = this.nextUnquotedValue();
        } else if (n == 8) {
            string = this.nextQuotedValue('\'');
        } else if (n == 9) {
            string = this.nextQuotedValue('\"');
        } else if (n == 11) {
            string = this.peekedString;
            this.peekedString = null;
        } else if (n == 15) {
            string = Long.toString(this.peekedLong);
        } else if (n == 16) {
            string = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else {
            throw new IllegalStateException("Expected a string but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 0;
        int n2 = this.stackSize - 1;
        this.pathIndices[n2] = this.pathIndices[n2] + 1;
        return string;
    }

    public boolean nextBoolean() throws IOException {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 5) {
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return true;
        }
        if (n == 6) {
            this.peeked = 0;
            int n3 = this.stackSize - 1;
            this.pathIndices[n3] = this.pathIndices[n3] + 1;
            return false;
        }
        throw new IllegalStateException("Expected a boolean but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public void nextNull() throws IOException {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 7) {
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return;
        }
        throw new IllegalStateException("Expected null but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public double nextDouble() throws IOException {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 15) {
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return this.peekedLong;
        }
        if (n == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n == 8 || n == 9) {
            this.peekedString = this.nextQuotedValue(n == 8 ? (char)'\'' : '\"');
        } else if (n == 10) {
            this.peekedString = this.nextUnquotedValue();
        } else if (n != 11) {
            throw new IllegalStateException("Expected a double but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 11;
        double d = Double.parseDouble(this.peekedString);
        if (!this.lenient && (Double.isNaN(d) || Double.isInfinite(d))) {
            throw new MalformedJsonException("JSON forbids NaN and infinities: " + d + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n3 = this.stackSize - 1;
        this.pathIndices[n3] = this.pathIndices[n3] + 1;
        return d;
    }

    public long nextLong() throws IOException {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 15) {
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return this.peekedLong;
        }
        if (n == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n == 8 || n == 9 || n == 10) {
            this.peekedString = n == 10 ? this.nextUnquotedValue() : this.nextQuotedValue(n == 8 ? (char)'\'' : '\"');
            try {
                long l = Long.parseLong(this.peekedString);
                this.peeked = 0;
                int n3 = this.stackSize - 1;
                this.pathIndices[n3] = this.pathIndices[n3] + 1;
                return l;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            throw new IllegalStateException("Expected a long but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 11;
        double d = Double.parseDouble(this.peekedString);
        long l = (long)d;
        if ((double)l != d) {
            throw new NumberFormatException("Expected a long but was " + this.peekedString + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n4 = this.stackSize - 1;
        this.pathIndices[n4] = this.pathIndices[n4] + 1;
        return l;
    }

    private String nextQuotedValue(char c) throws IOException {
        char[] cArray = this.buffer;
        StringBuilder stringBuilder = null;
        do {
            int n;
            int n2 = this.pos;
            int n3 = this.limit;
            int n4 = n2;
            while (n2 < n3) {
                if ((n = cArray[n2++]) == c) {
                    this.pos = n2;
                    n2 = n2 - n4 - 1;
                    if (stringBuilder == null) {
                        return new String(cArray, n4, n2);
                    }
                    stringBuilder.append(cArray, n4, n2);
                    return stringBuilder.toString();
                }
                if (n == 92) {
                    this.pos = n2;
                    n2 = n2 - n4 - 1;
                    if (stringBuilder == null) {
                        int n5 = n2 + 1 << 1;
                        stringBuilder = new StringBuilder(Math.max(n5, 16));
                    }
                    stringBuilder.append(cArray, n4, n2);
                    stringBuilder.append(this.readEscapeCharacter());
                    n2 = this.pos;
                    n3 = this.limit;
                    n4 = n2;
                    continue;
                }
                if (n != 10) continue;
                ++this.lineNumber;
                this.lineStart = n2;
            }
            if (stringBuilder == null) {
                n = n2 - n4 << 1;
                stringBuilder = new StringBuilder(Math.max(n, 16));
            }
            stringBuilder.append(cArray, n4, n2 - n4);
            this.pos = n2;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    private String nextUnquotedValue() throws IOException {
        CharSequence charSequence = null;
        int n = 0;
        block4: while (true) {
            if (this.pos + n < this.limit) {
                switch (this.buffer[this.pos + n]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        break block4;
                    }
                    default: {
                        ++n;
                    }
                }
                continue;
            }
            if (n < 1024) {
                if (!this.fillBuffer(n + 1)) break;
                continue;
            }
            if (charSequence == null) {
                charSequence = new StringBuilder(Math.max(n, 16));
            }
            charSequence.append(this.buffer, this.pos, n);
            this.pos += n;
            n = 0;
            if (!this.fillBuffer(1)) break;
        }
        charSequence = charSequence == null ? new String(this.buffer, this.pos, n) : charSequence.append(this.buffer, this.pos, n).toString();
        this.pos += n;
        return charSequence;
    }

    private void skipQuotedValue(char c) throws IOException {
        char[] cArray = this.buffer;
        do {
            int n = this.pos;
            int n2 = this.limit;
            while (n < n2) {
                char c2;
                if ((c2 = cArray[n++]) == c) {
                    this.pos = n;
                    return;
                }
                if (c2 == '\\') {
                    this.pos = n;
                    this.readEscapeCharacter();
                    n = this.pos;
                    n2 = this.limit;
                    continue;
                }
                if (c2 != '\n') continue;
                ++this.lineNumber;
                this.lineStart = n;
            }
            this.pos = n;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    public int nextInt() throws IOException {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 15) {
            n = (int)this.peekedLong;
            if (this.peekedLong != (long)n) {
                throw new NumberFormatException("Expected an int but was " + this.peekedLong + this.locationString());
            }
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return n;
        }
        if (n == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n == 8 || n == 9 || n == 10) {
            this.peekedString = n == 10 ? this.nextUnquotedValue() : this.nextQuotedValue(n == 8 ? (char)'\'' : '\"');
            try {
                n = Integer.parseInt(this.peekedString);
                this.peeked = 0;
                int n3 = this.stackSize - 1;
                this.pathIndices[n3] = this.pathIndices[n3] + 1;
                return n;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            throw new IllegalStateException("Expected an int but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 11;
        double d = Double.parseDouble(this.peekedString);
        n = (int)d;
        if ((double)n != d) {
            throw new NumberFormatException("Expected an int but was " + this.peekedString + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n4 = this.stackSize - 1;
        this.pathIndices[n4] = this.pathIndices[n4] + 1;
        return n;
    }

    @Override
    public void close() throws IOException {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.in.close();
    }

    public void skipValue() throws IOException {
        int n = 0;
        do {
            block23: {
                int n2;
                if ((n2 = this.peeked) == 0) {
                    n2 = this.doPeek();
                }
                if (n2 == 3) {
                    this.push(1);
                    ++n;
                } else if (n2 == 1) {
                    this.push(3);
                    ++n;
                } else if (n2 == 4) {
                    --this.stackSize;
                    --n;
                } else if (n2 == 2) {
                    --this.stackSize;
                    --n;
                } else if (n2 == 14 || n2 == 10) {
                    JsonReader jsonReader = this;
                    do {
                        int n3 = 0;
                        while (jsonReader.pos + n3 < jsonReader.limit) {
                            switch (jsonReader.buffer[jsonReader.pos + n3]) {
                                case '#': 
                                case '/': 
                                case ';': 
                                case '=': 
                                case '\\': {
                                    jsonReader.checkLenient();
                                }
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': 
                                case ',': 
                                case ':': 
                                case '[': 
                                case ']': 
                                case '{': 
                                case '}': {
                                    jsonReader.pos += n3;
                                    break block23;
                                }
                                default: {
                                    ++n3;
                                }
                            }
                        }
                        jsonReader.pos += n3;
                    } while (jsonReader.fillBuffer(1));
                } else if (n2 == 8 || n2 == 12) {
                    this.skipQuotedValue('\'');
                } else if (n2 == 9 || n2 == 13) {
                    this.skipQuotedValue('\"');
                } else if (n2 == 16) {
                    this.pos += this.peekedNumberLength;
                }
            }
            this.peeked = 0;
        } while (n != 0);
        int n4 = this.stackSize - 1;
        this.pathIndices[n4] = this.pathIndices[n4] + 1;
        this.pathNames[this.stackSize - 1] = "null";
    }

    private void push(int n) {
        if (this.stackSize == this.stack.length) {
            int[] nArray = new int[this.stackSize << 1];
            int[] nArray2 = new int[this.stackSize << 1];
            String[] stringArray = new String[this.stackSize << 1];
            System.arraycopy(this.stack, 0, nArray, 0, this.stackSize);
            System.arraycopy(this.pathIndices, 0, nArray2, 0, this.stackSize);
            System.arraycopy(this.pathNames, 0, stringArray, 0, this.stackSize);
            this.stack = nArray;
            this.pathIndices = nArray2;
            this.pathNames = stringArray;
        }
        this.stack[this.stackSize++] = n;
    }

    private boolean fillBuffer(int n) throws IOException {
        int n2;
        char[] cArray = this.buffer;
        this.lineStart -= this.pos;
        if (this.limit != this.pos) {
            this.limit -= this.pos;
            System.arraycopy(cArray, this.pos, cArray, 0, this.limit);
        } else {
            this.limit = 0;
        }
        this.pos = 0;
        while ((n2 = this.in.read(cArray, this.limit, 1024 - this.limit)) != -1) {
            this.limit += n2;
            if (this.lineNumber == 0 && this.lineStart == 0 && this.limit > 0 && cArray[0] == '\ufeff') {
                ++this.pos;
                ++this.lineStart;
                ++n;
            }
            if (this.limit < n) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int nextNonWhitespace(boolean bl) throws IOException {
        char[] cArray = this.buffer;
        int n = this.pos;
        int n2 = this.limit;
        block4: while (true) {
            int n3;
            if (n == n2) {
                this.pos = n;
                if (!this.fillBuffer(1)) break;
                n = this.pos;
                n2 = this.limit;
            }
            if ((n3 = cArray[n++]) == 10) {
                ++this.lineNumber;
                this.lineStart = n;
                continue;
            }
            if (n3 == 32 || n3 == 13 || n3 == 9) continue;
            if (n3 == 47) {
                this.pos = n;
                if (n == n2) {
                    --this.pos;
                    n = this.fillBuffer(2) ? 1 : 0;
                    ++this.pos;
                    if (n == 0) {
                        return n3;
                    }
                }
                this.checkLenient();
                switch (cArray[this.pos]) {
                    case '*': {
                        boolean bl2;
                        ++this.pos;
                        String string = "*/";
                        JsonReader jsonReader = this;
                        n3 = string.length();
                        block5: while (true) {
                            if (jsonReader.pos + n3 > jsonReader.limit && !jsonReader.fillBuffer(n3)) {
                                bl2 = false;
                                break;
                            }
                            if (jsonReader.buffer[jsonReader.pos] == '\n') {
                                ++jsonReader.lineNumber;
                                jsonReader.lineStart = jsonReader.pos + 1;
                            } else {
                                int n4 = 0;
                                while (true) {
                                    if (n4 >= n3) {
                                        bl2 = true;
                                        break block5;
                                    }
                                    if (jsonReader.buffer[jsonReader.pos + n4] != string.charAt(n4)) break;
                                    ++n4;
                                }
                            }
                            ++jsonReader.pos;
                        }
                        if (!bl2) {
                            throw this.syntaxError("Unterminated comment");
                        }
                        n = this.pos + 2;
                        n2 = this.limit;
                        continue block4;
                    }
                    case '/': {
                        ++this.pos;
                        this.skipToEndOfLine();
                        n = this.pos;
                        n2 = this.limit;
                        continue block4;
                    }
                }
                return n3;
            }
            if (n3 != 35) {
                this.pos = n;
                return n3;
            }
            this.pos = n;
            this.checkLenient();
            this.skipToEndOfLine();
            n = this.pos;
            n2 = this.limit;
        }
        if (bl) {
            throw new EOFException("End of input" + this.locationString());
        }
        return -1;
    }

    private void checkLenient() throws IOException {
        if (!this.lenient) {
            throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private void skipToEndOfLine() throws IOException {
        while (this.pos < this.limit || this.fillBuffer(1)) {
            char c;
            if ((c = this.buffer[this.pos++]) == '\n') {
                ++this.lineNumber;
                this.lineStart = this.pos;
                return;
            }
            if (c == '\r') break;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + this.locationString();
    }

    final String locationString() {
        int n = this.lineNumber + 1;
        int n2 = this.pos - this.lineStart + 1;
        return " at line " + n + " column " + n2 + " path " + this.getPath();
    }

    public String getPath() {
        StringBuilder stringBuilder = new StringBuilder("$");
        int n = 0;
        int n2 = this.stackSize;
        while (n < n2) {
            switch (this.stack[n]) {
                case 1: 
                case 2: {
                    stringBuilder.append('[').append(this.pathIndices[n]).append(']');
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    stringBuilder.append('.');
                    if (this.pathNames[n] == null) break;
                    stringBuilder.append(this.pathNames[n]);
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private char readEscapeCharacter() throws IOException {
        if (this.pos == this.limit && !this.fillBuffer(1)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        char c = this.buffer[this.pos++];
        switch (c) {
            case 'u': {
                if (this.pos + 4 > this.limit && !this.fillBuffer(4)) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                c = '\u0000';
                int n = this.pos;
                int n2 = n + 4;
                while (n < n2) {
                    char c2 = this.buffer[n];
                    c = (char)(c << 4);
                    if (c2 >= '0' && c2 <= '9') {
                        c = (char)(c + (c2 - 48));
                    } else if (c2 >= 'a' && c2 <= 'f') {
                        c = (char)(c + (c2 - 97 + 10));
                    } else if (c2 >= 'A' && c2 <= 'F') {
                        c = (char)(c + (c2 - 65 + 10));
                    } else {
                        throw new NumberFormatException("\\u" + new String(this.buffer, this.pos, 4));
                    }
                    ++n;
                }
                this.pos += 4;
                return c;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case '\n': {
                ++this.lineNumber;
                this.lineStart = this.pos;
            }
            case '\"': 
            case '\'': 
            case '/': 
            case '\\': {
                return c;
            }
        }
        throw this.syntaxError("Invalid escape sequence");
    }

    private IOException syntaxError(String string) throws IOException {
        throw new MalformedJsonException(String.valueOf(string) + this.locationString());
    }
}

