/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class ISO8601Utils {
    private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");

    /*
     * WARNING - void declaration
     */
    public static Date parse(String string, ParsePosition parsePosition) throws ParseException {
        void var2_12;
        try {
            TimeZone timeZone;
            int n = parsePosition.getIndex();
            int n2 = ISO8601Utils.parseInt(string, n, n += 4);
            if (ISO8601Utils.checkOffset(string, n, '-')) {
                // empty if block
            }
            int n3 = ISO8601Utils.parseInt(string, ++n, n += 2);
            if (ISO8601Utils.checkOffset(string, n, '-')) {
                // empty if block
            }
            int n4 = ISO8601Utils.parseInt(string, ++n, n += 2);
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = ISO8601Utils.checkOffset(string, n, 'T');
            if (n9 == 0 && string.length() <= n) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(n2, n3 - 1, n4);
                parsePosition.setIndex(n);
                return gregorianCalendar.getTime();
            }
            if (n9 != 0) {
                n5 = ISO8601Utils.parseInt(string, ++n, n += 2);
                if (ISO8601Utils.checkOffset(string, n, ':')) {
                    // empty if block
                }
                n6 = ISO8601Utils.parseInt(string, ++n, n += 2);
                if (ISO8601Utils.checkOffset(string, n, ':')) {
                    ++n;
                }
                if (string.length() > n && (n9 = string.charAt(n)) != 90 && n9 != 43 && n9 != 45) {
                    if ((n7 = ISO8601Utils.parseInt(string, n, n += 2)) > 59 && n7 < 63) {
                        n7 = 59;
                    }
                    if (ISO8601Utils.checkOffset(string, n, '.')) {
                        n9 = ISO8601Utils.indexOfNonDigit(string, ++n + 1);
                        int n10 = Math.min(n9, n + 3);
                        int n11 = ISO8601Utils.parseInt(string, n, n10);
                        switch (n10 - n) {
                            case 2: {
                                n8 = n11 * 10;
                                break;
                            }
                            case 1: {
                                n8 = n11 * 100;
                                break;
                            }
                            default: {
                                n8 = n11;
                            }
                        }
                        n = n9;
                    }
                }
            }
            if (string.length() <= n) {
                throw new IllegalArgumentException("No time zone indicator");
            }
            n9 = string.charAt(n);
            if (n9 == 90) {
                timeZone = TIMEZONE_UTC;
                ++n;
            } else if (n9 == 43 || n9 == 45) {
                String string2 = string.substring(n);
                string2 = string2.length() >= 5 ? string2 : String.valueOf(string2) + "00";
                n += string2.length();
                if ("+0000".equals(string2) || "+00:00".equals(string2)) {
                    timeZone = TIMEZONE_UTC;
                } else {
                    String string3 = "GMT" + string2;
                    timeZone = TimeZone.getTimeZone(string3);
                    if (!(string2 = timeZone.getID()).equals(string3) && !string2.replace(":", "").equals(string3)) {
                        throw new IndexOutOfBoundsException("Mismatching time zone indicator: " + string3 + " given, resolves to " + timeZone.getID());
                    }
                }
            } else {
                throw new IndexOutOfBoundsException("Invalid time zone indicator '" + (char)n9 + "'");
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.setLenient(false);
            gregorianCalendar.set(1, n2);
            gregorianCalendar.set(2, n3 - 1);
            gregorianCalendar.set(5, n4);
            gregorianCalendar.set(11, n5);
            gregorianCalendar.set(12, n6);
            gregorianCalendar.set(13, n7);
            gregorianCalendar.set(14, n8);
            parsePosition.setIndex(n);
            return gregorianCalendar.getTime();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String string4 = string == null ? null : "\"" + string + "'";
        String string5 = var2_12.getMessage();
        if (string5 == null || string5.isEmpty()) {
            string5 = "(" + var2_12.getClass().getName() + ")";
        }
        ParseException parseException = new ParseException("Failed to parse date [" + string4 + "]: " + string5, parsePosition.getIndex());
        parseException.initCause((Throwable)var2_12);
        throw parseException;
    }

    private static boolean checkOffset(String string, int n, char c) {
        return n < string.length() && string.charAt(n) == c;
    }

    private static int parseInt(String string, int n, int n2) throws NumberFormatException {
        int n3;
        if (n < 0 || n2 > string.length() || n > n2) {
            throw new NumberFormatException(string);
        }
        int n4 = n;
        int n5 = 0;
        if (n4 < n2) {
            if ((n3 = Character.digit(string.charAt(n4++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + string.substring(n, n2));
            }
            n5 = -n3;
        }
        while (n4 < n2) {
            if ((n3 = Character.digit(string.charAt(n4++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + string.substring(n, n2));
            }
            n5 = n5 * 10 - n3;
        }
        return -n5;
    }

    private static int indexOfNonDigit(String string, int n) {
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < '0' || c > '9') {
                return n;
            }
            ++n;
        }
        return string.length();
    }
}

