/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class ObjectTypeAdapter
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (typeToken.rawType == Object.class) {
                return new ObjectTypeAdapter(gson);
            }
            return null;
        }
    };
    private final Gson gson;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$google$gson$stream$JsonToken;

    ObjectTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    @Override
    public final Object read(JsonReader jsonReader) throws IOException {
        Object object = jsonReader.peek();
        switch (ObjectTypeAdapter.$SWITCH_TABLE$com$google$gson$stream$JsonToken()[((Enum)object).ordinal()]) {
            case 1: {
                object = new ArrayList();
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    object.add(this.read(jsonReader));
                }
                jsonReader.endArray();
                return object;
            }
            case 3: {
                object = new LinkedTreeMap();
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    object.put(jsonReader.nextName(), this.read(jsonReader));
                }
                jsonReader.endObject();
                return object;
            }
            case 6: {
                return jsonReader.nextString();
            }
            case 7: {
                return jsonReader.nextDouble();
            }
            case 8: {
                return jsonReader.nextBoolean();
            }
            case 9: {
                jsonReader.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public final void write(JsonWriter jsonWriter, Object object) throws IOException {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        TypeAdapter<?> typeAdapter = this.gson.getAdapter(object.getClass());
        if (typeAdapter instanceof ObjectTypeAdapter) {
            jsonWriter.beginObject();
            jsonWriter.endObject();
            return;
        }
        typeAdapter.write(jsonWriter, object);
    }

    private static /* synthetic */ int[] $SWITCH_TABLE$com$google$gson$stream$JsonToken() {
        if ($SWITCH_TABLE$com$google$gson$stream$JsonToken != null) {
            return $SWITCH_TABLE$com$google$gson$stream$JsonToken;
        }
        JsonToken.values();
        int[] nArray = new int[10];
        try {
            nArray[JsonToken.BEGIN_ARRAY.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.BEGIN_OBJECT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.BOOLEAN.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.END_ARRAY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.END_DOCUMENT.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.END_OBJECT.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.NAME.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.NULL.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.NUMBER.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.STRING.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$google$gson$stream$JsonToken = nArray;
        return nArray;
    }
}

