/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class LinkedTreeMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final Comparator<Comparable> NATURAL_ORDER = new Comparator<Comparable>(){};
    private Comparator<? super K> comparator;
    private Node<K, V> root;
    int size = 0;
    int modCount = 0;
    final Node<K, V> header = new Node();
    private EntrySet entrySet;
    private KeySet keySet;

    public LinkedTreeMap() {
        this(NATURAL_ORDER);
    }

    private LinkedTreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator != null ? comparator : NATURAL_ORDER;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final V get(Object node) {
        if ((node = this.findByObject(node)) != null) {
            return node.value;
        }
        return null;
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.findByObject(object) != null;
    }

    @Override
    public final V put(K object, V v) {
        if (object == null) {
            throw new NullPointerException("key == null");
        }
        object = this.find(object, true);
        Object v2 = ((Node)object).value;
        ((Node)object).value = v;
        return v2;
    }

    @Override
    public final void clear() {
        this.root = null;
        this.size = 0;
        ++this.modCount;
        this.header.prev = this.header.prev;
        this.header.prev.next = this.header.prev;
    }

    @Override
    public final V remove(Object node) {
        if ((node = this.removeInternalByKey(node)) != null) {
            return node.value;
        }
        return null;
    }

    private Node<K, V> find(K k, boolean bl) {
        Node<K, V> node;
        Object object;
        Comparator<K> comparator = this.comparator;
        Node<K, V> node2 = this.root;
        int n = 0;
        if (node2 != null) {
            object = comparator == NATURAL_ORDER ? (Comparable)k : null;
            while (true) {
                if ((n = object != null ? object.compareTo(node2.key) : comparator.compare(k, node2.key)) == 0) {
                    return node2;
                }
                node = n < 0 ? node2.left : node2.right;
                if (node == null) break;
                node2 = node;
            }
        }
        if (!bl) {
            return null;
        }
        object = this.header;
        if (node2 == null) {
            if (comparator == NATURAL_ORDER && !(k instanceof Comparable)) {
                throw new ClassCastException(String.valueOf(k.getClass().getName()) + " is not Comparable");
            }
            node = new Node<K, V>(node2, k, object, ((Node)object).prev);
            this.root = node;
        } else {
            node = new Node<K, V>(node2, k, object, ((Node)object).prev);
            if (n < 0) {
                node2.left = node;
            } else {
                node2.right = node;
            }
            this.rebalance(node2, true);
        }
        ++this.size;
        ++this.modCount;
        return node;
    }

    private Node<K, V> findByObject(Object object) {
        try {
            if (object != null) {
                return this.find(object, false);
            }
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    final Node<K, V> findByEntry(Map.Entry<?, ?> entry) {
        Object obj;
        Node<K, V> node = this.findByObject(entry.getKey());
        if (node != null && ((entry = node.value) == (obj = entry.getValue()) || entry != null && ((Object)entry).equals(obj))) {
            return node;
        }
        return null;
    }

    final void removeInternal(Node<K, V> node, boolean bl) {
        if (bl) {
            node.prev.next = node.next;
            node.next.prev = node.prev;
        }
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node.parent;
        if (node2 != null && node3 != null) {
            Node node5;
            if (node2.height > node3.height) {
                node3 = node2.right;
                while (node3 != null) {
                    node2 = node3;
                    node3 = node2.right;
                }
                node5 = node2;
            } else {
                node2 = node3;
                node3 = node2.left;
                while (node3 != null) {
                    node2 = node3;
                    node3 = node2.left;
                }
                node5 = node2;
            }
            node4 = node5;
            this.removeInternal(node4, false);
            int n = 0;
            node2 = node.left;
            if (node2 != null) {
                n = node2.height;
                node4.left = node2;
                node2.parent = node4;
                node.left = null;
            }
            int n2 = 0;
            node3 = node.right;
            if (node3 != null) {
                n2 = node3.height;
                node4.right = node3;
                node3.parent = node4;
                node.right = null;
            }
            node4.height = Math.max(n, n2) + 1;
            this.replaceInParent(node, node4);
            return;
        }
        if (node2 != null) {
            this.replaceInParent(node, node2);
            node.left = null;
        } else if (node3 != null) {
            this.replaceInParent(node, node3);
            node.right = null;
        } else {
            this.replaceInParent(node, null);
        }
        this.rebalance(node4, false);
        --this.size;
        ++this.modCount;
    }

    final Node<K, V> removeInternalByKey(Object node) {
        if ((node = this.findByObject(node)) != null) {
            this.removeInternal(node, true);
        }
        return node;
    }

    private void replaceInParent(Node<K, V> node, Node<K, V> node2) {
        Node node3 = node.parent;
        node.parent = null;
        if (node2 != null) {
            node2.parent = node3;
        }
        if (node3 != null) {
            if (node3.left == node) {
                node3.left = node2;
                return;
            }
            assert (node3.right == node);
            node3.right = node2;
            return;
        }
        this.root = node2;
    }

    private void rebalance(Node<K, V> node, boolean bl) {
        while (node != null) {
            Node node2;
            int n;
            Node node3 = node.left;
            int n2 = node3 != null ? node3.height : 0;
            int n3 = n2 - (n = (node2 = node.right) != null ? node2.height : 0);
            if (n3 == -2) {
                Node node4;
                Node node5 = node2.left;
                n2 = (node5 != null ? node5.height : 0) - (n = (node4 = node2.right) != null ? node4.height : 0);
                if (n2 == -1 || n2 == 0 && !bl) {
                    this.rotateLeft(node);
                } else {
                    assert (n2 == 1);
                    this.rotateRight(node2);
                    this.rotateLeft(node);
                }
                if (bl) {
                    return;
                }
            } else if (n3 == 2) {
                Node node6;
                Node node7 = node3.left;
                n2 = (node7 != null ? node7.height : 0) - (n = (node6 = node3.right) != null ? node6.height : 0);
                if (n2 == 1 || n2 == 0 && !bl) {
                    this.rotateRight(node);
                } else {
                    assert (n2 == -1);
                    this.rotateLeft(node3);
                    this.rotateRight(node);
                }
                if (bl) {
                    return;
                }
            } else if (n3 == 0) {
                node.height = n2 + 1;
                if (bl) {
                    return;
                }
            } else {
                assert (n3 == -1 || n3 == 1);
                node.height = Math.max(n2, n) + 1;
                if (!bl) break;
            }
            node = node.parent;
        }
    }

    private void rotateLeft(Node<K, V> node) {
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node3.left;
        Node node5 = node3.right;
        node.right = node4;
        if (node4 != null) {
            node4.parent = node;
        }
        this.replaceInParent(node, node3);
        node3.left = node;
        node.parent = node3;
        node.height = Math.max(node2 != null ? node2.height : 0, node4 != null ? node4.height : 0) + 1;
        node3.height = Math.max(node.height, node5 != null ? node5.height : 0) + 1;
    }

    private void rotateRight(Node<K, V> node) {
        Node node2 = node.left;
        Node node3 = node.right;
        Node node4 = node2.left;
        Node node5 = node2.right;
        node.left = node5;
        if (node5 != null) {
            node5.parent = node;
        }
        this.replaceInParent(node, node2);
        node2.right = node;
        node.parent = node2;
        node.height = Math.max(node3 != null ? node3.height : 0, node5 != null ? node5.height : 0) + 1;
        node2.height = Math.max(node.height, node4 != null ? node4.height : 0) + 1;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet != null) {
            return entrySet;
        }
        this.entrySet = new EntrySet(this);
        return this.entrySet;
    }

    @Override
    public final Set<K> keySet() {
        KeySet keySet = this.keySet;
        if (keySet != null) {
            return keySet;
        }
        this.keySet = new KeySet(this);
        return this.keySet;
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private /* synthetic */ LinkedTreeMap this$0;

        EntrySet(LinkedTreeMap linkedTreeMap) {
            this.this$0 = linkedTreeMap;
        }

        @Override
        public final int size() {
            return this.this$0.size;
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new LinkedTreeMapIterator<Map.Entry<K, V>>(this.this$0){};
        }

        @Override
        public final boolean contains(Object object) {
            return object instanceof Map.Entry && this.this$0.findByEntry((Map.Entry)object) != null;
        }

        @Override
        public final boolean remove(Object node) {
            if (!(node instanceof Map.Entry)) {
                return false;
            }
            if ((node = this.this$0.findByEntry(node)) == null) {
                return false;
            }
            this.this$0.removeInternal(node, true);
            return true;
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        private /* synthetic */ LinkedTreeMap this$0;

        KeySet(LinkedTreeMap linkedTreeMap) {
            this.this$0 = linkedTreeMap;
        }

        @Override
        public final int size() {
            return this.this$0.size;
        }

        @Override
        public final Iterator<K> iterator() {
            return new LinkedTreeMapIterator<K>(this.this$0){

                @Override
                public final K next() {
                    return this.nextNode().key;
                }
            };
        }

        @Override
        public final boolean contains(Object object) {
            return this.this$0.containsKey(object);
        }

        @Override
        public final boolean remove(Object object) {
            return this.this$0.removeInternalByKey(object) != null;
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    abstract class LinkedTreeMapIterator<T>
    implements Iterator<T> {
        private Node<K, V> next;
        private Node<K, V> lastReturned;
        private int expectedModCount;
        private /* synthetic */ LinkedTreeMap this$0;

        LinkedTreeMapIterator(LinkedTreeMap linkedTreeMap) {
            this.this$0 = linkedTreeMap;
            this.next = linkedTreeMap.header.next;
            this.lastReturned = null;
            this.expectedModCount = linkedTreeMap.modCount;
        }

        @Override
        public final boolean hasNext() {
            return this.next != this.this$0.header;
        }

        final Node<K, V> nextNode() {
            Node node = this.next;
            if (node == this.this$0.header) {
                throw new NoSuchElementException();
            }
            if (this.this$0.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = node.next;
            this.lastReturned = node;
            return this.lastReturned;
        }

        @Override
        public final void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.this$0.removeInternal(this.lastReturned, true);
            this.lastReturned = null;
            this.expectedModCount = this.this$0.modCount;
        }
    }

    static final class Node<K, V>
    implements Map.Entry<K, V> {
        Node<K, V> parent;
        Node<K, V> left;
        Node<K, V> right;
        Node<K, V> next;
        Node<K, V> prev;
        final K key;
        V value;
        int height;

        Node() {
            this.key = null;
            this.next = this.prev = this;
        }

        Node(Node<K, V> node, K k, Node<K, V> node2, Node<K, V> node3) {
            this.parent = node;
            this.key = k;
            this.height = 1;
            this.next = node2;
            this.prev = node3;
            node3.next = this;
            node2.prev = this;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public final boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                object = (Map.Entry)object;
                return (this.key == null ? object.getKey() == null : this.key.equals(object.getKey())) && (this.value == null ? object.getValue() == null : this.value.equals(object.getValue()));
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }
    }
}

