/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.Since;
import com.google.gson.annotations.Until;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Excluder
implements TypeAdapterFactory,
Cloneable {
    public static final Excluder DEFAULT = new Excluder();
    public double version = -1.0;
    public int modifiers = 136;
    public boolean serializeInnerClasses = true;
    public List<ExclusionStrategy> serializationStrategies = Collections.emptyList();
    public List<ExclusionStrategy> deserializationStrategies = Collections.emptyList();

    private Excluder clone() {
        try {
            return (Excluder)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    @Override
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Class clazz = typeToken.rawType;
        boolean bl = this.excludeClass(clazz, true);
        boolean bl2 = this.excludeClass(clazz, false);
        if (!bl && !bl2) {
            return null;
        }
        return new TypeAdapter<T>(this, bl2, bl, gson, typeToken){
            private TypeAdapter<T> delegate;
            private /* synthetic */ Excluder this$0;
            private final /* synthetic */ boolean val$skipDeserialize;
            private final /* synthetic */ boolean val$skipSerialize;
            private final /* synthetic */ Gson val$gson;
            private final /* synthetic */ TypeToken val$type;
            {
                this.this$0 = excluder;
                this.val$skipDeserialize = bl;
                this.val$skipSerialize = bl2;
                this.val$gson = gson;
                this.val$type = typeToken;
            }

            @Override
            public final T read(JsonReader jsonReader) throws IOException {
                if (this.val$skipDeserialize) {
                    jsonReader.skipValue();
                    return null;
                }
                return this.delegate().read(jsonReader);
            }

            @Override
            public final void write(JsonWriter jsonWriter, T t) throws IOException {
                if (this.val$skipSerialize) {
                    jsonWriter.nullValue();
                    return;
                }
                this.delegate().write(jsonWriter, t);
            }

            private TypeAdapter<T> delegate() {
                TypeAdapter typeAdapter = this.delegate;
                if (typeAdapter != null) {
                    return typeAdapter;
                }
                this.delegate = this.val$gson.getDelegateAdapter(this.this$0, this.val$type);
                return this.delegate;
            }
        };
    }

    public final boolean excludeClass(Class<?> clazz, boolean bl) {
        if (this.version != -1.0 && !this.isValidVersion(clazz.getAnnotation(Since.class), clazz.getAnnotation(Until.class))) {
            return true;
        }
        if (!this.serializeInnerClasses && Excluder.isInnerClass(clazz)) {
            return true;
        }
        if (Excluder.isAnonymousOrLocal(clazz)) {
            return true;
        }
        Iterator<ExclusionStrategy> iterator = (bl ? this.serializationStrategies : this.deserializationStrategies).iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().shouldSkipClass$1b2d8b94()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnonymousOrLocal(Class<?> clazz) {
        return !Enum.class.isAssignableFrom(clazz) && (clazz.isAnonymousClass() || clazz.isLocalClass());
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !((clazz.getModifiers() & 8) != 0);
    }

    public final boolean isValidVersion(Since object, Until until) {
        Annotation annotation = object;
        object = this;
        if (annotation == null || !(annotation.value() > ((Excluder)object).version)) {
            annotation = until;
            object = this;
            if (annotation == null || !(annotation.value() <= ((Excluder)object).version)) {
                return true;
            }
        }
        return false;
    }
}

