/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.FieldAttributes;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;

public final class $Gson$Types {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    private static GenericArrayType arrayOf(Type type) {
        return new GenericArrayTypeImpl(type);
    }

    public static Type canonicalize(Type type) {
        if (type instanceof Class) {
            if (((Class)(type = (Class)type)).isArray()) {
                return new GenericArrayTypeImpl($Gson$Types.canonicalize(((Class)type).getComponentType()));
            }
            return type;
        }
        if (type instanceof ParameterizedType) {
            type = (ParameterizedType)type;
            return new ParameterizedTypeImpl(type.getOwnerType(), type.getRawType(), type.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            type = (GenericArrayType)type;
            return new GenericArrayTypeImpl(type.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            type = (WildcardType)type;
            return new WildcardTypeImpl(type.getUpperBounds(), type.getLowerBounds());
        }
        return type;
    }

    public static Class<?> getRawType(Type type) {
        while (true) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
                FieldAttributes.checkArgument(type instanceof Class);
                return (Class)type;
            }
            if (type instanceof GenericArrayType) {
                return Array.newInstance($Gson$Types.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
            }
            if (type instanceof TypeVariable) {
                return Object.class;
            }
            if (!(type instanceof WildcardType)) break;
            type = ((WildcardType)type).getUpperBounds()[0];
        }
        String string = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + string);
    }

    public static boolean equals(Type type, Type type2) {
        while (true) {
            if (type == type2) {
                return true;
            }
            if (type instanceof Class) {
                return type.equals(type2);
            }
            if (type instanceof ParameterizedType) {
                if (!(type2 instanceof ParameterizedType)) {
                    return false;
                }
                type = (ParameterizedType)type;
                type2 = (ParameterizedType)type2;
                Type type3 = type2.getOwnerType();
                Type type4 = type.getOwnerType();
                return (type4 == type3 || type4 != null && type4.equals(type3)) && type.getRawType().equals(type2.getRawType()) && Arrays.equals(type.getActualTypeArguments(), type2.getActualTypeArguments());
            }
            if (!(type instanceof GenericArrayType)) break;
            if (!(type2 instanceof GenericArrayType)) {
                return false;
            }
            type = (GenericArrayType)type;
            type2 = (GenericArrayType)type2;
            type2 = type2.getGenericComponentType();
            type = type.getGenericComponentType();
        }
        if (type instanceof WildcardType) {
            if (!(type2 instanceof WildcardType)) {
                return false;
            }
            type = (WildcardType)type;
            type2 = (WildcardType)type2;
            return Arrays.equals(type.getUpperBounds(), type2.getUpperBounds()) && Arrays.equals(type.getLowerBounds(), type2.getLowerBounds());
        }
        if (type instanceof TypeVariable) {
            if (!(type2 instanceof TypeVariable)) {
                return false;
            }
            type = (TypeVariable)type;
            type2 = (TypeVariable)type2;
            return type.getGenericDeclaration() == type2.getGenericDeclaration() && type.getName().equals(type2.getName());
        }
        return false;
    }

    static int hashCodeOrZero(Object object) {
        if (object != null) {
            return object.hashCode();
        }
        return 0;
    }

    public static String typeToString(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return type.toString();
    }

    private static Type getGenericSupertype(Type object, Class<?> object2, Class<?> clazz) {
        block0: while (true) {
            if (clazz == object2) {
                return object;
            }
            if (clazz.isInterface()) {
                object = ((Class)object2).getInterfaces();
                int n = 0;
                int n2 = ((Class<?>[])object).length;
                while (n < n2) {
                    if (object[n] == clazz) {
                        return ((Class)object2).getGenericInterfaces()[n];
                    }
                    if (clazz.isAssignableFrom(object[n])) {
                        Type type = ((Class)object2).getGenericInterfaces()[n];
                        object2 = object[n];
                        object = type;
                        continue block0;
                    }
                    ++n;
                }
            }
            if (((Class)object2).isInterface()) break;
            while (object2 != Object.class) {
                object = ((Class)object2).getSuperclass();
                if (object == clazz) {
                    return ((Class)object2).getGenericSuperclass();
                }
                if (clazz.isAssignableFrom((Class<?>)object)) {
                    Type type = ((Class)object2).getGenericSuperclass();
                    object2 = object;
                    object = type;
                    continue block0;
                }
                object2 = object;
            }
            break;
        }
        return clazz;
    }

    private static Type getSupertype(Type type, Class<?> clazz, Class<?> clazz2) {
        FieldAttributes.checkArgument(clazz2.isAssignableFrom(clazz));
        return $Gson$Types.resolve(type, clazz, $Gson$Types.getGenericSupertype(type, clazz, clazz2));
    }

    public static Type getArrayComponentType(Type type) {
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        return ((Class)type).getComponentType();
    }

    public static Type getCollectionElementType(Type type, Class<?> clazz) {
        if ((type = $Gson$Types.getSupertype(type, clazz, Collection.class)) instanceof WildcardType) {
            type = ((WildcardType)type).getUpperBounds()[0];
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static Type[] getMapKeyAndValueTypes(Type type, Class<?> clazz) {
        if (type == Properties.class) {
            return new Type[]{String.class, String.class};
        }
        if ((type = $Gson$Types.getSupertype(type, clazz, Map.class)) instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return new Type[]{Object.class, Object.class};
    }

    public static Type resolve(Type type, Class<?> clazz, Type type2) {
        return $Gson$Types.resolve(type, clazz, type2, new HashSet<TypeVariable>());
    }

    private static Type resolve(Type type, Class<?> clazz, Type object, Collection<TypeVariable> collection) {
        Type type2;
        Type type3;
        while (object instanceof TypeVariable) {
            Object object2;
            type3 = (TypeVariable)object;
            if (collection.contains(type3)) {
                return object;
            }
            collection.add((TypeVariable)type3);
            type2 = type3;
            Class<?> clazz2 = clazz;
            object = type;
            Object object3 = type2.getGenericDeclaration();
            TypeVariable<Class<T>>[] typeVariableArray = object3 instanceof Class ? (TypeVariable<Class<T>>[])object3 : null;
            if (typeVariableArray != null && (object = $Gson$Types.getGenericSupertype((Type)object, clazz2, typeVariableArray)) instanceof ParameterizedType) {
                int n;
                block20: {
                    object3 = type2;
                    typeVariableArray = typeVariableArray.getTypeParameters();
                    n = 0;
                    int n2 = typeVariableArray.length;
                    while (n < n2) {
                        if (!object3.equals(typeVariableArray[n])) {
                            ++n;
                            continue;
                        }
                        break block20;
                    }
                    throw new NoSuchElementException();
                }
                object2 = ((ParameterizedType)object).getActualTypeArguments()[n];
            } else {
                object2 = object = type2;
            }
            if (object2 != type3) continue;
            return object;
        }
        if (object instanceof Class && ((Class)object).isArray()) {
            Type type4;
            type3 = (Class)object;
            if ((object = ((Class)type3).getComponentType()) == (type4 = $Gson$Types.resolve(type, clazz, object, collection))) {
                return type3;
            }
            return $Gson$Types.arrayOf(type4);
        }
        if (object instanceof GenericArrayType) {
            Type type5;
            type3 = (GenericArrayType)object;
            if ((object = type3.getGenericComponentType()) == (type5 = $Gson$Types.resolve(type, clazz, object, collection))) {
                return type3;
            }
            return $Gson$Types.arrayOf(type5);
        }
        if (object instanceof ParameterizedType) {
            type3 = (ParameterizedType)object;
            Type type6 = $Gson$Types.resolve(type, clazz, object = type3.getOwnerType(), collection);
            boolean bl = type6 != object;
            object = type3.getActualTypeArguments();
            int n = 0;
            int n3 = ((Type[])object).length;
            while (n < n3) {
                Type type7 = $Gson$Types.resolve(type, clazz, object[n], collection);
                if (type7 != object[n]) {
                    if (!bl) {
                        object = (Type[])object.clone();
                        bl = true;
                    }
                    object[n] = type7;
                }
                ++n;
            }
            if (bl) {
                Type type8 = type6;
                Type[] typeArray = object;
                type6 = type3.getRawType();
                object = type8;
                return new ParameterizedTypeImpl((Type)object, type6, typeArray);
            }
            return type3;
        }
        if (object instanceof WildcardType) {
            type3 = (WildcardType)object;
            object = type3.getLowerBounds();
            Type[] typeArray = type3.getUpperBounds();
            if (((Type[])object).length == 1) {
                type2 = $Gson$Types.resolve(type, clazz, object[0], collection);
                if (type2 != object[0]) {
                    object = type2;
                    typeArray = object instanceof WildcardType ? ((WildcardType)object).getLowerBounds() : new Type[]{object};
                    return new WildcardTypeImpl(new Type[]{Object.class}, typeArray);
                }
            } else if (typeArray.length == 1 && (type2 = $Gson$Types.resolve(type, clazz, typeArray[0], collection)) != typeArray[0]) {
                object = type2;
                typeArray = object instanceof WildcardType ? ((WildcardType)object).getUpperBounds() : new Type[]{object};
                return new WildcardTypeImpl(typeArray, EMPTY_TYPE_ARRAY);
            }
            return type3;
        }
        return object;
    }

    static void checkNotPrimitive(Type type) {
        FieldAttributes.checkArgument(!(type instanceof Class) || !((Class)type).isPrimitive());
    }

    static final class GenericArrayTypeImpl
    implements Serializable,
    GenericArrayType {
        private final Type componentType;

        public GenericArrayTypeImpl(Type type) {
            this.componentType = $Gson$Types.canonicalize(type);
        }

        @Override
        public final Type getGenericComponentType() {
            return this.componentType;
        }

        public final boolean equals(Object object) {
            return object instanceof GenericArrayType && $Gson$Types.equals(this, (GenericArrayType)object);
        }

        public final int hashCode() {
            return this.componentType.hashCode();
        }

        public final String toString() {
            return String.valueOf($Gson$Types.typeToString(this.componentType)) + "[]";
        }
    }

    static final class ParameterizedTypeImpl
    implements Serializable,
    ParameterizedType {
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;

        public ParameterizedTypeImpl(Type type, Type type2, Type ... typeArray) {
            int n;
            if (type2 instanceof Class) {
                Class clazz = (Class)type2;
                n = !Modifier.isStatic(clazz.getModifiers()) && clazz.getEnclosingClass() != null ? 0 : 1;
                FieldAttributes.checkArgument(type != null || n != 0);
            }
            this.ownerType = type == null ? null : $Gson$Types.canonicalize(type);
            this.rawType = $Gson$Types.canonicalize(type2);
            this.typeArguments = (Type[])typeArray.clone();
            int n2 = 0;
            n = this.typeArguments.length;
            while (n2 < n) {
                FieldAttributes.checkNotNull(this.typeArguments[n2]);
                $Gson$Types.checkNotPrimitive(this.typeArguments[n2]);
                this.typeArguments[n2] = $Gson$Types.canonicalize(this.typeArguments[n2]);
                ++n2;
            }
        }

        @Override
        public final Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public final Type getRawType() {
            return this.rawType;
        }

        @Override
        public final Type getOwnerType() {
            return this.ownerType;
        }

        public final boolean equals(Object object) {
            return object instanceof ParameterizedType && $Gson$Types.equals(this, (ParameterizedType)object);
        }

        public final int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ $Gson$Types.hashCodeOrZero(this.ownerType);
        }

        public final String toString() {
            int n = this.typeArguments.length;
            if (n == 0) {
                return $Gson$Types.typeToString(this.rawType);
            }
            StringBuilder stringBuilder = new StringBuilder(30 * (n + 1));
            stringBuilder.append($Gson$Types.typeToString(this.rawType)).append("<").append($Gson$Types.typeToString(this.typeArguments[0]));
            int n2 = 1;
            while (n2 < n) {
                stringBuilder.append(", ").append($Gson$Types.typeToString(this.typeArguments[n2]));
                ++n2;
            }
            return stringBuilder.append(">").toString();
        }
    }

    static final class WildcardTypeImpl
    implements Serializable,
    WildcardType {
        private final Type upperBound;
        private final Type lowerBound;

        public WildcardTypeImpl(Type[] typeArray, Type[] typeArray2) {
            FieldAttributes.checkArgument(typeArray2.length <= 1);
            FieldAttributes.checkArgument(typeArray.length == 1);
            if (typeArray2.length == 1) {
                FieldAttributes.checkNotNull(typeArray2[0]);
                $Gson$Types.checkNotPrimitive(typeArray2[0]);
                FieldAttributes.checkArgument(typeArray[0] == Object.class);
                this.lowerBound = $Gson$Types.canonicalize(typeArray2[0]);
                this.upperBound = Object.class;
                return;
            }
            FieldAttributes.checkNotNull(typeArray[0]);
            $Gson$Types.checkNotPrimitive(typeArray[0]);
            this.lowerBound = null;
            this.upperBound = $Gson$Types.canonicalize(typeArray[0]);
        }

        @Override
        public final Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public final Type[] getLowerBounds() {
            if (this.lowerBound != null) {
                return new Type[]{this.lowerBound};
            }
            return EMPTY_TYPE_ARRAY;
        }

        public final boolean equals(Object object) {
            return object instanceof WildcardType && $Gson$Types.equals(this, (WildcardType)object);
        }

        public final int hashCode() {
            return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
        }

        public final String toString() {
            if (this.lowerBound != null) {
                return "? super " + $Gson$Types.typeToString(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + $Gson$Types.typeToString(this.upperBound);
        }
    }
}

