/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.bind.ArrayTypeAdapter;
import com.google.gson.internal.bind.CollectionTypeAdapterFactory;
import com.google.gson.internal.bind.DateTypeAdapter;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.internal.bind.ObjectTypeAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.internal.bind.SqlDateTypeAdapter;
import com.google.gson.internal.bind.TimeTypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public final class Gson {
    private static final TypeToken<?> NULL_KEY_SURROGATE = TypeToken.get(Object.class);
    private final ThreadLocal<Map<TypeToken<?>, FutureTypeAdapter<?>>> calls = new ThreadLocal();
    private final Map<TypeToken<?>, TypeAdapter<?>> typeTokenCache = new ConcurrentHashMap();
    private final List<TypeAdapterFactory> factories;
    private final ConstructorConstructor constructorConstructor;
    public final boolean lenient;
    private final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;

    public Gson() {
        this(Excluder.DEFAULT, FieldNamingPolicy.IDENTITY, Collections.emptyMap(), LongSerializationPolicy.DEFAULT, Collections.emptyList());
    }

    private Gson(Excluder excluder, ExclusionStrategy exclusionStrategy, Map<Type, ExclusionStrategy<?>> object, LongSerializationPolicy object2, final List<TypeAdapterFactory> object3) {
        this.constructorConstructor = new ConstructorConstructor((Map<Type, ExclusionStrategy<?>>)object);
        this.lenient = false;
        object = new ArrayList<TypeAdapterFactory>();
        object.add(TypeAdapters.JSON_ELEMENT_FACTORY);
        object.add(ObjectTypeAdapter.FACTORY);
        object.add(excluder);
        object.addAll(object3);
        object.add(TypeAdapters.STRING_FACTORY);
        object.add(TypeAdapters.INTEGER_FACTORY);
        object.add(TypeAdapters.BOOLEAN_FACTORY);
        object.add(TypeAdapters.BYTE_FACTORY);
        object.add(TypeAdapters.SHORT_FACTORY);
        object2 = object2 == LongSerializationPolicy.DEFAULT ? TypeAdapters.LONG : new TypeAdapter<Number>(){};
        object.add(TypeAdapters.newFactory(Long.TYPE, Long.class, object2));
        object.add(TypeAdapters.newFactory(Double.TYPE, Double.class, new TypeAdapter<Number>(){}));
        object.add(TypeAdapters.newFactory(Float.TYPE, Float.class, new TypeAdapter<Number>(){}));
        object.add(TypeAdapters.NUMBER_FACTORY);
        object.add(TypeAdapters.ATOMIC_INTEGER_FACTORY);
        object.add(TypeAdapters.ATOMIC_BOOLEAN_FACTORY);
        object3 = object2;
        object.add(TypeAdapters.newFactory(AtomicLong.class, new TypeAdapter<AtomicLong>(){}.nullSafe()));
        object3 = object2;
        object.add(TypeAdapters.newFactory(AtomicLongArray.class, new TypeAdapter<AtomicLongArray>(){}.nullSafe()));
        object.add(TypeAdapters.ATOMIC_INTEGER_ARRAY_FACTORY);
        object.add(TypeAdapters.CHARACTER_FACTORY);
        object.add(TypeAdapters.STRING_BUILDER_FACTORY);
        object.add(TypeAdapters.STRING_BUFFER_FACTORY);
        object.add(TypeAdapters.newFactory(BigDecimal.class, TypeAdapters.BIG_DECIMAL));
        object.add(TypeAdapters.newFactory(BigInteger.class, TypeAdapters.BIG_INTEGER));
        object.add(TypeAdapters.URL_FACTORY);
        object.add(TypeAdapters.URI_FACTORY);
        object.add(TypeAdapters.UUID_FACTORY);
        object.add(TypeAdapters.CURRENCY_FACTORY);
        object.add(TypeAdapters.LOCALE_FACTORY);
        object.add(TypeAdapters.INET_ADDRESS_FACTORY);
        object.add(TypeAdapters.BIT_SET_FACTORY);
        object.add(DateTypeAdapter.FACTORY);
        object.add(TypeAdapters.CALENDAR_FACTORY);
        object.add(TimeTypeAdapter.FACTORY);
        object.add(SqlDateTypeAdapter.FACTORY);
        object.add(TypeAdapters.TIMESTAMP_FACTORY);
        object.add(ArrayTypeAdapter.FACTORY);
        object.add(TypeAdapters.CLASS_FACTORY);
        object.add(new CollectionTypeAdapterFactory(this.constructorConstructor));
        object.add(new MapTypeAdapterFactory(this.constructorConstructor));
        this.jsonAdapterFactory = new JsonAdapterAnnotationTypeAdapterFactory(this.constructorConstructor);
        object.add(this.jsonAdapterFactory);
        object.add(TypeAdapters.ENUM_FACTORY);
        object.add(new ReflectiveTypeAdapterFactory(this.constructorConstructor, exclusionStrategy, excluder));
        this.factories = Collections.unmodifiableList(object);
    }

    static void checkValidFloatingPoint(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException(String.valueOf(d) + " is not a valid double value as per JSON specification. To override this behavior, use GsonBuilder.serializeSpecialFloatingPointValues() method.");
        }
    }

    public final <T> TypeAdapter<T> getAdapter(TypeToken<T> typeToken) {
        TypeAdapter typeAdapter;
        Object object = this.typeTokenCache.get(typeToken == null ? NULL_KEY_SURROGATE : typeToken);
        if (object != null) {
            return object;
        }
        object = this.calls.get();
        boolean bl = false;
        if (object == null) {
            object = new HashMap();
            this.calls.set((Map<TypeToken<?>, FutureTypeAdapter<?>>)object);
            bl = true;
        }
        if ((typeAdapter = (FutureTypeAdapter)object.get(typeToken)) != null) {
            return typeAdapter;
        }
        try {
            typeAdapter = new FutureTypeAdapter();
            object.put(typeToken, typeAdapter);
            Object object2 = this.factories.iterator();
            while (object2.hasNext()) {
                TypeAdapter<T> typeAdapter2 = object2.next().create(this, typeToken);
                if (typeAdapter2 == null) continue;
                object2 = typeAdapter2;
                if (typeAdapter.delegate != null) {
                    throw new AssertionError();
                }
                typeAdapter.delegate = object2;
                this.typeTokenCache.put(typeToken, typeAdapter2);
                typeAdapter = typeAdapter2;
                return typeAdapter;
            }
            throw new IllegalArgumentException("GSON cannot handle " + typeToken);
        }
        finally {
            object.remove(typeToken);
            if (bl) {
                this.calls.remove();
            }
        }
    }

    public final <T> TypeAdapter<T> getDelegateAdapter(TypeAdapterFactory typeAdapterFactory, TypeToken<T> typeToken) {
        if (!this.factories.contains(typeAdapterFactory)) {
            typeAdapterFactory = this.jsonAdapterFactory;
        }
        boolean bl = false;
        for (TypeAdapterFactory typeAdapterFactory2 : this.factories) {
            if (!bl) {
                if (typeAdapterFactory2 != typeAdapterFactory) continue;
                bl = true;
                continue;
            }
            TypeAdapter<T> typeAdapter = typeAdapterFactory2.create(this, typeToken);
            if (typeAdapter == null) continue;
            return typeAdapter;
        }
        throw new IllegalArgumentException("GSON cannot serialize " + typeToken);
    }

    public final <T> TypeAdapter<T> getAdapter(Class<T> clazz) {
        return this.getAdapter(TypeToken.get(clazz));
    }

    public final String toJson(Object object, Type object2) {
        StringWriter stringWriter;
        Closeable closeable = stringWriter = new StringWriter();
        Object object3 = object2;
        object2 = object;
        object = this;
        try {
            closeable = closeable;
            closeable = new JsonWriter((Writer)closeable);
            v0.serializeNulls = false;
            object3 = ((Gson)object).getAdapter(TypeToken.get((Type)object3));
            boolean bl = ((JsonWriter)closeable).lenient;
            ((JsonWriter)closeable).lenient = true;
            boolean bl2 = ((JsonWriter)closeable).htmlSafe;
            ((JsonWriter)closeable).htmlSafe = true;
            boolean bl3 = ((JsonWriter)closeable).serializeNulls;
            ((JsonWriter)closeable).serializeNulls = false;
            try {
                try {
                    ((TypeAdapter)object3).write((JsonWriter)closeable, object2);
                }
                catch (IOException iOException) {
                    throw new JsonIOException(iOException);
                }
            }
            finally {
                ((JsonWriter)closeable).lenient = bl;
                ((JsonWriter)closeable).htmlSafe = bl2;
                ((JsonWriter)closeable).serializeNulls = bl3;
            }
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        return stringWriter.toString();
    }

    public static void assertFullConsumption(Object object, JsonReader jsonReader) {
        try {
            if (object != null && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException("JSON document was not fully consumed.");
            }
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public final <T> T fromJson(JsonReader jsonReader, Type object) throws JsonIOException, JsonSyntaxException {
        boolean bl = true;
        boolean bl2 = jsonReader.lenient;
        jsonReader.lenient = true;
        try {
            jsonReader.peek();
            bl = false;
            object = TypeToken.get((Type)object);
            object = this.getAdapter((TypeToken<T>)object).read(jsonReader);
            return (T)object;
        }
        catch (EOFException eOFException) {
            if (bl) {
                return null;
            }
            throw new JsonSyntaxException(eOFException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new JsonSyntaxException(illegalStateException);
        }
        catch (IOException iOException) {
            throw new JsonSyntaxException(iOException);
        }
        finally {
            jsonReader.lenient = bl2;
        }
    }

    public final String toString() {
        return "{serializeNulls:false,factories:" + this.factories + ",instanceCreators:" + this.constructorConstructor + "}";
    }

    static final class FutureTypeAdapter<T>
    extends TypeAdapter<T> {
        TypeAdapter<T> delegate;

        FutureTypeAdapter() {
        }

        @Override
        public final T read(JsonReader jsonReader) throws IOException {
            if (this.delegate == null) {
                throw new IllegalStateException();
            }
            return this.delegate.read(jsonReader);
        }

        @Override
        public final void write(JsonWriter jsonWriter, T t) throws IOException {
            if (this.delegate == null) {
                throw new IllegalStateException();
            }
            this.delegate.write(jsonWriter, t);
        }
    }
}

